/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.coord.moon;

import gaiasky.util.coord.AstroUtils;
import gaiasky.util.math.Vector3D;
import net.jafama.FastMath;

public class MoonMeeusCoordinates {
    private static final double[][] table47a = new double[][]{{0.0, 0.0, 1.0, 0.0, 6288774.0, -2.0905355E7}, {2.0, 0.0, -1.0, 0.0, 1274027.0, -3699111.0}, {2.0, 0.0, 0.0, 0.0, 658314.0, -2955968.0}, {0.0, 0.0, 2.0, 0.0, 213618.0, -569925.0}, {0.0, 1.0, 0.0, 0.0, -185116.0, 48888.0}, {0.0, 0.0, 0.0, 2.0, -114332.0, -3149.0}, {2.0, 0.0, -2.0, 0.0, 58793.0, 246158.0}, {2.0, -1.0, -1.0, 0.0, 57066.0, -152138.0}, {2.0, 0.0, 1.0, 0.0, 53322.0, -170733.0}, {2.0, -1.0, 0.0, 0.0, 45758.0, -204586.0}, {0.0, 1.0, -1.0, 0.0, -40923.0, -129620.0}, {1.0, 0.0, 0.0, 0.0, -34720.0, 108743.0}, {0.0, 1.0, 1.0, 0.0, -30383.0, 104755.0}, {2.0, 0.0, 0.0, -2.0, 15327.0, 10321.0}, {0.0, 0.0, 1.0, 2.0, -12528.0, 0.0}, {0.0, 0.0, 1.0, -2.0, 10980.0, 79661.0}, {4.0, 0.0, -1.0, 0.0, 10675.0, -34782.0}, {0.0, 0.0, 3.0, 0.0, 10034.0, -23210.0}, {4.0, 0.0, -2.0, 0.0, 8548.0, -21636.0}, {2.0, 1.0, -1.0, 0.0, -7888.0, 24208.0}, {2.0, 1.0, 0.0, 0.0, -6766.0, 30824.0}, {1.0, 0.0, -1.0, 0.0, -5163.0, -8379.0}, {1.0, 1.0, 0.0, 0.0, 4987.0, -16675.0}, {2.0, -1.0, 1.0, 0.0, 4036.0, -12831.0}, {2.0, 0.0, 2.0, 0.0, 3994.0, -10445.0}, {4.0, 0.0, 0.0, 0.0, 3861.0, -11650.0}, {2.0, 0.0, -3.0, 0.0, 3665.0, 14403.0}, {0.0, 1.0, -2.0, 0.0, -2689.0, -7003.0}, {2.0, 0.0, -1.0, 2.0, -2602.0, 0.0}, {2.0, -1.0, -2.0, 0.0, 2390.0, 10056.0}, {1.0, 0.0, 1.0, 0.0, -2348.0, 6322.0}, {2.0, -2.0, 0.0, 0.0, 2236.0, -9884.0}, {0.0, 1.0, 2.0, 0.0, -2120.0, 5751.0}, {0.0, 2.0, 0.0, 0.0, -2069.0, 0.0}, {2.0, -2.0, -1.0, 0.0, 2048.0, -4950.0}, {2.0, 0.0, 1.0, -2.0, -1773.0, 4130.0}, {2.0, 0.0, 0.0, 2.0, -1595.0, 0.0}, {4.0, -1.0, -1.0, 0.0, 1215.0, -3958.0}, {0.0, 0.0, 2.0, 2.0, -1110.0, 0.0}, {3.0, 0.0, -1.0, 0.0, -892.0, 3258.0}, {2.0, 1.0, 1.0, 0.0, -810.0, 2616.0}, {4.0, -1.0, -2.0, 0.0, 759.0, -1897.0}, {0.0, 2.0, -1.0, 0.0, -713.0, -2117.0}, {2.0, 2.0, -1.0, 0.0, -700.0, 2354.0}, {2.0, 1.0, -2.0, 0.0, 691.0, 0.0}, {2.0, -1.0, 0.0, -2.0, 596.0, 0.0}, {4.0, 0.0, 1.0, 0.0, 549.0, -1423.0}, {0.0, 0.0, 4.0, 0.0, 537.0, -1117.0}, {4.0, -1.0, 0.0, 0.0, 520.0, -1571.0}, {1.0, 0.0, -2.0, 0.0, -487.0, -1739.0}, {2.0, 1.0, 0.0, -2.0, -399.0, 0.0}, {0.0, 0.0, 2.0, -2.0, -381.0, -4421.0}, {1.0, 1.0, 1.0, 0.0, 351.0, 0.0}, {3.0, 0.0, -2.0, 0.0, -340.0, 0.0}, {4.0, 0.0, -3.0, 0.0, 330.0, 0.0}, {2.0, -1.0, 2.0, 0.0, 327.0, 0.0}, {0.0, 2.0, 1.0, 0.0, -323.0, 1165.0}, {1.0, 1.0, -1.0, 0.0, 299.0, 0.0}, {2.0, 0.0, 3.0, 0.0, 294.0, 0.0}, {2.0, 0.0, -1.0, -2.0, 0.0, 8752.0}};
    private static final double[][] table47b = new double[][]{{0.0, 0.0, 0.0, 1.0, 5128122.0}, {0.0, 0.0, 1.0, 1.0, 280602.0}, {0.0, 0.0, 1.0, -1.0, 277693.0}, {2.0, 0.0, 0.0, -1.0, 173237.0}, {2.0, 0.0, -1.0, 1.0, 55413.0}, {2.0, 0.0, -1.0, -1.0, 46271.0}, {2.0, 0.0, 0.0, 1.0, 32573.0}, {0.0, 0.0, 2.0, 1.0, 17198.0}, {2.0, 0.0, 1.0, -1.0, 9266.0}, {0.0, 0.0, 2.0, -1.0, 8822.0}, {2.0, -1.0, 0.0, -1.0, 8216.0}, {2.0, 0.0, -2.0, -1.0, 4324.0}, {2.0, 0.0, 1.0, 1.0, 4200.0}, {2.0, 1.0, 0.0, -1.0, -3359.0}, {2.0, -1.0, -1.0, 1.0, 2463.0}, {2.0, -1.0, 0.0, 1.0, 2211.0}, {2.0, -1.0, -1.0, -1.0, 2065.0}, {0.0, 1.0, -1.0, -1.0, -1870.0}, {4.0, 0.0, -1.0, -1.0, 1828.0}, {0.0, 1.0, 0.0, 1.0, -1794.0}, {0.0, 0.0, 0.0, 3.0, -1749.0}, {0.0, 1.0, -1.0, 1.0, -1565.0}, {1.0, 0.0, 0.0, 1.0, -1491.0}, {0.0, 1.0, 1.0, 1.0, -1475.0}, {0.0, 1.0, 1.0, -1.0, -1410.0}, {0.0, 1.0, 0.0, -1.0, -1344.0}, {1.0, 0.0, 0.0, -1.0, -1335.0}, {0.0, 0.0, 3.0, 1.0, 1107.0}, {4.0, 0.0, 0.0, -1.0, 1021.0}, {4.0, 0.0, -1.0, 1.0, 833.0}, {0.0, 0.0, 1.0, -3.0, 777.0}, {4.0, 0.0, -2.0, 1.0, 671.0}, {2.0, 0.0, 0.0, -3.0, 607.0}, {2.0, 0.0, 2.0, -1.0, 596.0}, {2.0, -1.0, 1.0, -1.0, 491.0}, {2.0, 0.0, -2.0, 1.0, -451.0}, {0.0, 0.0, 3.0, -1.0, 439.0}, {2.0, 0.0, 2.0, 1.0, 422.0}, {2.0, 0.0, -3.0, -1.0, 421.0}, {2.0, 1.0, -1.0, 1.0, -366.0}, {2.0, 1.0, 0.0, 1.0, -351.0}, {4.0, 0.0, 0.0, 1.0, 331.0}, {2.0, -1.0, 1.0, 1.0, 315.0}, {2.0, -2.0, 0.0, -1.0, 302.0}, {0.0, 0.0, 1.0, 3.0, -283.0}, {2.0, 1.0, 1.0, -1.0, -229.0}, {1.0, 1.0, 0.0, -1.0, 223.0}, {1.0, 1.0, 0.0, 1.0, 223.0}, {0.0, 1.0, -2.0, -1.0, -220.0}, {2.0, 1.0, -1.0, -1.0, -220.0}, {1.0, 0.0, 1.0, 1.0, -185.0}, {2.0, -1.0, -2.0, -1.0, 181.0}, {0.0, 1.0, 2.0, 1.0, -177.0}, {4.0, 0.0, -2.0, -1.0, 176.0}, {4.0, -1.0, -1.0, -1.0, 166.0}, {1.0, 0.0, 1.0, -1.0, -164.0}, {4.0, 0.0, 1.0, -1.0, 132.0}, {1.0, 0.0, -1.0, -1.0, -119.0}, {4.0, -1.0, 0.0, -1.0, 115.0}, {2.0, -2.0, 0.0, 1.0, 107.0}};

    public static Vector3D moonEclipticCoordinates(double julianDate, Vector3D out) {
        double T = AstroUtils.T(julianDate);
        double T2 = T * T;
        double T3 = T2 * T;
        double T4 = T3 * T;
        double Lp = 218.3164477 + 481267.88123421 * T - 0.0015786 * T2 + T3 / 538841.0 - T4 / 6.5194E7;
        Lp = MoonMeeusCoordinates.prettyAngle(Lp);
        double D = 297.8501921 + 445267.1114034 * T - 0.0018819 * T2 + T3 / 545868.0 - T4 / 1.13065E8;
        D = MoonMeeusCoordinates.prettyAngle(D);
        double M = 357.5291092 + 35999.0502909 * T - 1.536E-4 * T2 + T3 / 2.449E7;
        M = MoonMeeusCoordinates.prettyAngle(M);
        double Mp = 134.9633964 + 477198.8675055 * T + 0.0087414 * T2 + T3 / 69699.0 - T4 / 1.4712E7;
        Mp = MoonMeeusCoordinates.prettyAngle(Mp);
        double F = 93.272095 + 483202.0175233 * T - 0.0036539 * T2 - T3 / 3526000.0 + T4 / 8.6331E8;
        F = MoonMeeusCoordinates.prettyAngle(F);
        double A1 = 119.75 + 131.849 * T;
        A1 = MoonMeeusCoordinates.prettyAngle(A1);
        double A2 = 53.09 + 479264.29 * T;
        A2 = MoonMeeusCoordinates.prettyAngle(A2);
        double A3 = 313.45 + 481266.484 * T;
        A3 = MoonMeeusCoordinates.prettyAngle(A3);
        double E = 1.0 - 0.002516 * T - 7.4E-6 * T2;
        double[] aux = MoonMeeusCoordinates.calculateSumlSumr(D, M, Mp, F, E, A1, A2, Lp);
        double sumL = aux[0];
        double sumR = aux[1];
        double sumB = MoonMeeusCoordinates.calculateSumb(D, M, Mp, F, E, A1, A3, Lp);
        double lambda = MoonMeeusCoordinates.prettyAngle(Lp + sumL * 1.0E-6);
        double beta = MoonMeeusCoordinates.declination(MoonMeeusCoordinates.prettyAngle(sumB * 1.0E-6));
        double dist = 385000.56 + sumR * 0.001;
        return out.set(Math.toRadians(lambda), FastMath.toRadians((double)beta), dist);
    }

    private static double[] calculateSumlSumr(double D, double M, double Mp, double F, double E, double A1, double A2, double Lp) {
        double suml = 0.0;
        double sumr = 0.0;
        for (double[] curr : table47a) {
            double mul = 1.0;
            if (curr[1] == 1.0 || curr[1] == -1.0) {
                mul = E;
            } else if (curr[1] == 2.0 || curr[1] == -2.0) {
                mul = E * E;
            }
            double argument = FastMath.toRadians((double)(curr[0] * D + curr[1] * M + curr[2] * Mp + curr[3] * F));
            suml += curr[4] * mul * FastMath.sin((double)argument);
            sumr += curr[5] * mul * FastMath.cos((double)argument);
        }
        double sumladd = 3958.0 * FastMath.sin((double)Math.toRadians(A1)) + 1962.0 * FastMath.sin((double)Math.toRadians(Lp - F)) + 318.0 * FastMath.sin((double)Math.toRadians(A2));
        return new double[]{suml += sumladd, sumr};
    }

    private static double calculateSumb(double D, double M, double Mp, double F, double E, double A1, double A3, double Lp) {
        double sumB = 0.0;
        for (double[] curr : table47b) {
            double mul = 1.0;
            if (curr[1] == 1.0 || curr[1] == -1.0) {
                mul = E;
            } else if (curr[1] == 2.0 || curr[1] == -2.0) {
                mul = E * E;
            }
            sumB += curr[4] * mul * FastMath.sin((double)Math.toRadians(curr[0] * D + curr[1] * M + curr[2] * Mp + curr[3] * F));
        }
        double sumBAdd = -2235.0 * FastMath.sin((double)Math.toRadians(Lp)) + 382.0 * FastMath.sin((double)Math.toRadians(A3)) + 175.0 * FastMath.sin((double)Math.toRadians(A1 - F)) + 175.0 * FastMath.sin((double)Math.toRadians(A1 + F)) + 127.0 * FastMath.sin((double)Math.toRadians(Lp - Mp)) - 115.0 * FastMath.sin((double)Math.toRadians(Lp + Mp));
        return sumB += sumBAdd;
    }

    private static double prettyAngle(double angle) {
        return angle - 360.0 * (double)((int)(angle / 360.0));
    }

    private static double declination(double angle) {
        return FastMath.abs((double)angle) <= 90.0 ? angle : angle - 360.0;
    }
}

