/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.coord.vsop2000;

import gaiasky.util.Constants;
import gaiasky.util.Settings;
import gaiasky.util.coord.AbstractOrbitCoordinates;
import gaiasky.util.coord.AstroUtils;
import gaiasky.util.coord.Coordinates;
import gaiasky.util.coord.vsop2000.VSOP2000Reader;
import gaiasky.util.math.Vector3Q;
import java.nio.file.Path;
import java.time.Instant;
import net.jafama.FastMath;

public class VSOP2000
extends AbstractOrbitCoordinates {
    private final double[][] meanMotionsLongitudes = new double[][]{{26.0879031405997, 4.40260863422}, {10.2132855473855, 3.17613445715}, {6.2830758504457, 1.75346994632}, {3.3406124347175, 6.20349959869}, {0.5296909721118, 0.59954667809}, {0.2132990797783, 0.87401678345}, {0.0747816656905, 5.48122762581}, {0.0381329181312, 5.31189410499}, {0.025350505, 4.1708192}, {77.7137714681205, 5.19846674103}, {84.3346615813083, 1.62790523337}, {83.2869142695536, 2.35555589827}, {17.311765022, 4.0914977581}, {17.044507911, 1.7178014632}, {14.289030168, 5.5933513169}, {13.647633749, 2.8062767856}, {13.61949504, 2.0348605335}};
    private double lastT = Double.NaN;
    private final double[] theta = new double[16];
    private String dataFile;
    private VSOP2000Reader.VSOP2000Coordinate[] data;

    public void setDataFile(String dataFile) {
        this.dataFile = dataFile;
    }

    public boolean initialize() {
        if (this.data == null) {
            if (this.dataFile != null) {
                VSOP2000Reader reader = new VSOP2000Reader();
                try {
                    this.data = reader.read(Path.of(this.dataFile, new String[0]));
                    return this.data != null;
                }
                catch (Exception e) {
                    logger.error("Error initializing coordinates: " + this.dataFile, e);
                    return false;
                }
            }
            return false;
        }
        return true;
    }

    public void position(Instant date, Vector3Q out) {
        if (!this.initialize()) {
            return;
        }
        int maxTerms = Settings.settings.data.highAccuracy ? 2000 : 500;
        double t = VSOP2000.time(AstroUtils.getJulianDateCache(date));
        VSOP2000Reader.VSOP2000Coordinate[] d = this.data;
        if (this.lastT != t) {
            for (int j = 0; j < 16; ++j) {
                this.theta[j] = this.meanMotionsLongitudes[j][0] * t + this.meanMotionsLongitudes[j][1];
            }
            this.lastT = t;
        }
        double[] coordinates = new double[3];
        for (int coord = 0; coord < 3; ++coord) {
            double sum_k = 0.0;
            for (int k = 0; k < 16; ++k) {
                VSOP2000Reader.VSOP2000Coordinate c = d[coord];
                int n_k = FastMath.min((int)c.numTerms[k], (int)maxTerms);
                if (n_k == 0) break;
                double sum_i = 0.0;
                for (int i = 0; i < n_k; ++i) {
                    double phi_ki = 0.0;
                    for (int j = 0; j < 16; ++j) {
                        phi_ki += c.terms[k][i][j] * this.theta[j];
                    }
                    sum_i += c.terms[k][i][17] * FastMath.sin((double)phi_ki) + c.terms[k][i][18] * FastMath.cos((double)phi_ki);
                }
                sum_k += FastMath.pow((double)t, (double)k) * sum_i;
            }
            coordinates[coord] = sum_k * Constants.AU_TO_U;
        }
        out.set(coordinates[1], coordinates[2], coordinates[0]);
    }

    public static double time(double julianDate) {
        return (julianDate - 2451545.0) / 365.25;
    }

    @Override
    public Vector3Q getEclipticSphericalCoordinates(Instant instant, Vector3Q out) {
        this.position(instant, out);
        Coordinates.cartesianToSpherical(out, out);
        return out;
    }

    @Override
    public Vector3Q getEclipticCartesianCoordinates(Instant instant, Vector3Q out) {
        this.position(instant, out);
        return out;
    }

    @Override
    public Vector3Q getEquatorialCartesianCoordinates(Instant instant, Vector3Q out) {
        this.position(instant, out);
        out.mul(Coordinates.eclToEq());
        return out;
    }
}

