/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.coord.vsop2000;

import gaiasky.util.parse.Parser;
import java.io.FileNotFoundException;
import java.nio.file.Path;
import java.util.Scanner;

public class VSOP2000Reader {
    public VSOP2000Coordinate[] read(Path file) throws FileNotFoundException {
        VSOP2000Coordinate[] result = new VSOP2000Coordinate[3];
        Scanner s = new Scanner(file.toFile());
        for (int ci = 0; ci < 3; ++ci) {
            String h = s.nextLine().strip();
            String[] hTokens = h.split("\\s+");
            int bodyIndex = Parser.parseIntException(hTokens[1]);
            String bodyName = hTokens[2];
            String coordName = hTokens[3];
            VSOP2000Coordinate coord = new VSOP2000Coordinate();
            coord.idx = bodyIndex;
            coord.body = bodyName;
            coord.coordinate = coordName;
            result[ci] = coord;
            for (int ti = 0; ti < 16; ++ti) {
                int termSize;
                String t = s.nextLine().strip();
                coord.numTerms[ti] = termSize = Parser.parseIntException(t);
                coord.terms[ti] = (double[][])(termSize > 0 ? new double[termSize][19] : null);
            }
            for (int r = 0; r < 16; ++r) {
                if (coord.numTerms[r] <= 0) continue;
                s.nextLine();
                int numRecords = coord.numTerms[r];
                for (int line = 0; line < numRecords; ++line) {
                    double[] record = coord.terms[r][line];
                    String l = s.nextLine();
                    int pos = 8;
                    for (int iCoeff = 0; iCoeff < 17; ++iCoeff) {
                        int len = iCoeff != 0 && iCoeff % 4 == 0 ? 4 : 3;
                        String coeffStr = l.substring(pos, pos + len).trim();
                        int coeff = Parser.parseIntException(coeffStr);
                        record[iCoeff] = coeff;
                        pos += len;
                    }
                    String[] sc = l.substring(pos += 9).trim().split("\\s+");
                    double s_ki = Parser.parseDoubleException(sc[0].replace("D", "E"));
                    double c_ki = Parser.parseDoubleException(sc[1].replace("D", "E"));
                    record[17] = s_ki;
                    record[18] = c_ki;
                }
            }
        }
        return result;
    }

    public static class VSOP2000Coordinate {
        int idx;
        String body;
        String coordinate;
        int[] numTerms = new int[16];
        double[][][] terms = new double[16][][];
    }
}

