/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.coord.vsop87;

import gaiasky.data.AssetBean;
import gaiasky.util.Constants;
import gaiasky.util.Settings;
import gaiasky.util.coord.AbstractOrbitCoordinates;
import gaiasky.util.coord.AstroUtils;
import gaiasky.util.coord.Coordinates;
import gaiasky.util.coord.vsop87.VSOP87Binary;
import gaiasky.util.coord.vsop87.VSOP87Loader;
import gaiasky.util.coord.vsop87.iVSOP87;
import gaiasky.util.math.Vector3Q;
import java.time.Instant;

public abstract class AbstractVSOP87
extends AbstractOrbitCoordinates
implements iVSOP87 {
    private static final String dataFile = "$data/default-data/vsop87/vsop87a.bin";
    protected static VSOP87Binary vsop87;
    private final boolean versionA;

    protected AbstractVSOP87() {
        if (vsop87 == null) {
            AssetBean.addAsset(dataFile, VSOP87Binary.class, new VSOP87Loader.VSOP87LoaderParameters(Settings.settings.data.highAccuracy ? 0.0 : 0.6));
        }
        this.versionA = dataFile.contains("vsop87a");
    }

    @Override
    public void doneLoading(Object ... params) {
        super.doneLoading(params);
        if (vsop87 == null && AssetBean.manager().isLoaded(dataFile)) {
            vsop87 = (VSOP87Binary)AssetBean.manager().get(dataFile, VSOP87Binary.class);
        }
    }

    public abstract double[] getData(double var1);

    @Override
    public Vector3Q getEclipticSphericalCoordinates(Instant date, Vector3Q out) {
        return this.versionA ? this.getEclipticSphericalCoordinatesA(date, out) : this.getEclipticSphericalCoordinatesB(date, out);
    }

    public Vector3Q getEclipticSphericalCoordinatesA(Instant date, Vector3Q out) {
        Vector3Q v = this.getEclipticCartesianCoordinates(date, out);
        if (v == null) {
            return null;
        }
        Coordinates.cartesianToSpherical(out, out);
        return out;
    }

    public Vector3Q getEclipticSphericalCoordinatesB(Instant date, Vector3Q out) {
        if (Constants.notWithinVSOPTime(date.toEpochMilli())) {
            return null;
        }
        double tau = AstroUtils.tau(AstroUtils.getJulianDateCache(date));
        double[] BLR = this.getData(tau);
        if (BLR != null) {
            double B = BLR[0];
            double L = BLR[1];
            double R = BLR[2] * Constants.AU_TO_U * this.scaling;
            out.set(L, B, R);
            return out;
        }
        return null;
    }

    @Override
    public Vector3Q getEclipticCartesianCoordinates(Instant date, Vector3Q out) {
        return this.versionA ? this.getEclipticCartesianCoordinatesA(date, out) : this.getEclipticSphericalCoordinatesB(date, out);
    }

    public Vector3Q getEclipticCartesianCoordinatesA(Instant date, Vector3Q out) {
        if (Constants.notWithinVSOPTime(date.toEpochMilli())) {
            return null;
        }
        double tau = AstroUtils.tau(AstroUtils.getJulianDateCache(date));
        double[] XYZ = this.getData(tau);
        if (XYZ != null) {
            double X = XYZ[0] * Constants.AU_TO_U * this.scaling;
            double Y = XYZ[1] * Constants.AU_TO_U * this.scaling;
            double Z = XYZ[2] * Constants.AU_TO_U * this.scaling;
            out.set(Y, Z, X);
            return out;
        }
        return null;
    }

    public Vector3Q getEclipticCartesianCoordinatesB(Instant date, Vector3Q out) {
        Vector3Q v = this.getEclipticSphericalCoordinates(date, out);
        if (v == null) {
            return null;
        }
        Coordinates.sphericalToCartesian(out, out);
        return out;
    }

    @Override
    public Vector3Q getEquatorialCartesianCoordinates(Instant date, Vector3Q out) {
        Vector3Q v = this.getEclipticCartesianCoordinates(date, out);
        if (v == null) {
            return null;
        }
        out.mul(Coordinates.eclToEq());
        return out;
    }
}

