/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.coord.vsop87;

import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.AsynchronousAssetLoader;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.Array;
import gaiasky.util.Logger;
import gaiasky.util.Settings;
import gaiasky.util.coord.vsop87.VSOP87Binary;

public class VSOP87Loader
extends AsynchronousAssetLoader<VSOP87Binary, VSOP87LoaderParameters> {
    private static final Logger.Log logger = Logger.getLogger(VSOP87Loader.class);
    private VSOP87Binary vsop87;

    public VSOP87Loader(FileHandleResolver resolver) {
        super(resolver);
    }

    public void loadAsync(AssetManager assetManager, String s, FileHandle fileHandle, VSOP87LoaderParameters vsop87LoaderParameters) {
        try {
            String fullPath = Settings.settings.data.dataFile(s);
            this.vsop87 = new VSOP87Binary(fullPath, vsop87LoaderParameters.percentSkipped);
        }
        catch (Exception e) {
            logger.error(e);
        }
    }

    public VSOP87Binary loadSync(AssetManager assetManager, String s, FileHandle fileHandle, VSOP87LoaderParameters vsop87LoaderParameters) {
        return this.vsop87;
    }

    public Array<AssetDescriptor> getDependencies(String s, FileHandle fileHandle, VSOP87LoaderParameters vsop87LoaderParameters) {
        return null;
    }

    public static class VSOP87LoaderParameters
    extends AssetLoaderParameters<VSOP87Binary> {
        public double percentSkipped;

        public VSOP87LoaderParameters(double percentSkipped) {
            this.percentSkipped = percentSkipped;
        }
    }
}

