/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.datadesc;

import gaiasky.util.datadesc.DatasetDesc;
import gaiasky.util.datadesc.DatasetType;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;

public class DataDescriptor {
    public static DataDescriptor localDataDescriptor;
    public static DataDescriptor serverDataDescriptor;
    public List<DatasetType> types;
    public List<DatasetDesc> datasets;
    public String[] recommended;
    public boolean updatesAvailable = false;
    public int numUpdates = 0;

    public DataDescriptor(List<DatasetType> types, List<DatasetDesc> datasets, String[] recommended) {
        this.types = types;
        this.datasets = datasets;
        this.recommended = recommended;
        for (DatasetDesc ds : datasets) {
            boolean bl = this.updatesAvailable = this.updatesAvailable || ds.outdated;
            if (!ds.outdated) continue;
            ++this.numUpdates;
        }
    }

    public DataDescriptor(List<DatasetType> types, List<DatasetDesc> datasets) {
        this(types, datasets, null);
    }

    public DatasetDesc findDatasetByName(String name) {
        for (DatasetDesc dd : this.datasets) {
            if (!dd.name.equalsIgnoreCase(name)) continue;
            return dd;
        }
        return null;
    }

    public DatasetDesc findDatasetByKey(String key) {
        for (DatasetDesc dd : this.datasets) {
            if (!dd.key.equalsIgnoreCase(key)) continue;
            return dd;
        }
        return null;
    }

    public boolean datasetPresent(String key) {
        DatasetDesc dd = this.findDatasetByKey(key);
        if (dd != null) {
            return dd.exists;
        }
        return false;
    }

    public DatasetDesc findDatasetByDescriptor(Path descriptorFile) throws IOException {
        if (Files.exists(descriptorFile, new LinkOption[0])) {
            for (DatasetDesc dd : this.datasets) {
                if (dd.checkPath == null || !Files.exists(dd.checkPath, new LinkOption[0]) || !Files.isSameFile(dd.checkPath, descriptorFile)) continue;
                return dd;
            }
        }
        return null;
    }
}

