/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.datadesc;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.JsonReader;
import com.badlogic.gdx.utils.JsonValue;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.gui.datasets.DatasetManagerWindow;
import gaiasky.util.Logger;
import gaiasky.util.Settings;
import gaiasky.util.datadesc.DataDescriptor;
import gaiasky.util.datadesc.DatasetDesc;
import gaiasky.util.datadesc.DatasetType;
import gaiasky.util.i18n.I18n;
import gaiasky.util.update.VersionChecker;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.FileUtils;

public class DataDescriptorUtils {
    private static final Logger.Log logger = Logger.getLogger(DataDescriptorUtils.class);
    private static DataDescriptorUtils instance;
    private final JsonReader reader = new JsonReader();
    private FileHandle fh;
    private static final Set<String> specialDirectories;

    private DataDescriptorUtils() {
    }

    public static DataDescriptorUtils instance() {
        if (instance == null) {
            instance = new DataDescriptorUtils();
        }
        return instance;
    }

    public static boolean dataLocationOldVersionDatasetsCheck() {
        boolean bl;
        block9: {
            Path dataLocation = Path.of(Settings.settings.data.location, new String[0]);
            if (Files.exists(dataLocation.resolve("data-main.json"), new LinkOption[0])) {
                return true;
            }
            Stream<Path> stream = Files.list(dataLocation);
            try {
                long num = stream.filter(p -> {
                    if (p.toFile().isFile() && p.getFileName().toString().endsWith(".json")) {
                        return true;
                    }
                    return p.toFile().isDirectory() && !p.equals(dataLocation) && !p.resolve("dataset.json").toFile().exists() && !specialDirectories.contains(p.getFileName().toString());
                }).count();
                boolean bl2 = bl = num > 0L;
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    logger.warn(e);
                    return false;
                }
            }
            stream.close();
        }
        return bl;
    }

    public static void cleanDataLocationOldDatasets() {
        Path dataLocation = Path.of(Settings.settings.data.location, new String[0]);
        try (Stream<Path> stream = Files.list(dataLocation);){
            List<Path> toDelete = stream.filter(p -> {
                if (p.toFile().isFile() && p.getFileName().toString().endsWith(".json")) {
                    return true;
                }
                return p.toFile().isDirectory() && !p.equals(dataLocation) && !p.resolve("dataset.json").toFile().exists() && !specialDirectories.contains(p.getFileName().toString());
            }).toList();
            if (!toDelete.isEmpty()) {
                for (Path delete : toDelete) {
                    if (!Files.exists(delete, new LinkOption[0])) continue;
                    String message = I18n.msg("gui.dscheck.deleting", ": data/" + delete.getFileName().toString());
                    logger.info(message);
                    EventManager.publish(Event.POST_POPUP_NOTIFICATION, dataLocation, message, Float.valueOf(5.0f));
                    FileUtils.deleteQuietly((File)delete.toFile());
                }
                String message = I18n.msg("gui.dscheck.finish");
                logger.info(message);
                EventManager.publish(Event.POST_POPUP_NOTIFICATION, dataLocation, message, Float.valueOf(5.0f));
            }
        }
        catch (Exception e) {
            logger.warn(e);
        }
    }

    public synchronized DataDescriptor buildServerDatasets(FileHandle fh) {
        if (fh != null) {
            this.fh = fh;
        }
        if (this.fh != null) {
            InputStream inputStream;
            logger.info("Building data descriptor model from file: " + String.valueOf(this.fh.file().toPath()));
            try {
                FileInputStream fis = new FileInputStream(this.fh.file());
                try {
                    inputStream = new GZIPInputStream(fis);
                }
                catch (IOException e) {
                    logger.info("Not a gzipped file, trying uncompressed.");
                    inputStream = new FileInputStream(this.fh.file());
                }
            }
            catch (FileNotFoundException e) {
                logger.error("Error reading file: " + String.valueOf(this.fh.file().toPath()));
                return null;
            }
            try {
                DataDescriptor desc;
                JsonValue dataDesc = this.reader.parse(inputStream);
                HashMap<String, JsonValue> bestDs = new HashMap<String, JsonValue>();
                HashMap typeMap = new HashMap();
                LinkedHashSet<String> types = new LinkedHashSet<String>();
                JsonValue rec = dataDesc.get("recommended");
                String[] recommended = null;
                if (rec != null) {
                    try {
                        recommended = rec.asStringArray();
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                }
                JsonValue item = dataDesc.get("files").child();
                while (item != null) {
                    boolean hasMinGsVersion = item.has("mingsversion");
                    int minGsVersion = VersionChecker.correctVersionNumber(item.getInt("mingsversion", 0));
                    int thisVersion = item.getInt("version", 0);
                    if (hasMinGsVersion && 3061001 >= minGsVersion && minGsVersion >= 3030100) {
                        String dsKey;
                        String type = item.getString("type");
                        String string = dsKey = item.has("key") ? item.getString("key") : item.getString("name");
                        if (bestDs.containsKey(dsKey)) {
                            JsonValue other = (JsonValue)bestDs.get(dsKey);
                            int otherVersion = other.getInt("version", 0);
                            if (otherVersion >= thisVersion) {
                                item = item.next();
                                continue;
                            }
                            ((List)typeMap.get(type)).remove(other);
                            bestDs.remove(dsKey);
                        }
                        if (typeMap.containsKey(type)) {
                            ((List)typeMap.get(type)).add(item);
                        } else {
                            ArrayList<JsonValue> aux = new ArrayList<JsonValue>();
                            aux.add(item);
                            typeMap.put(type, aux);
                        }
                        types.add(type);
                        bestDs.put(dsKey, item);
                    }
                    item = item.next();
                }
                ArrayList<DatasetType> typesList = new ArrayList<DatasetType>(types.size());
                ArrayList<DatasetDesc> datasetsList = new ArrayList<DatasetDesc>();
                for (String typeStr : types) {
                    List datasets = (List)typeMap.get(typeStr);
                    DatasetType currentType = new DatasetType(typeStr);
                    for (JsonValue dataset : datasets) {
                        DatasetDesc dd = new DatasetDesc(this.reader, dataset);
                        dd.datasetType = currentType;
                        currentType.addDataset(dd);
                        datasetsList.add(dd);
                    }
                    typesList.add(currentType);
                }
                DataDescriptor.serverDataDescriptor = desc = new DataDescriptor(typesList, datasetsList, recommended);
                return desc;
            }
            catch (Exception e) {
                logger.error(e);
                return null;
            }
        }
        return null;
    }

    public synchronized DataDescriptor buildLocalDatasets(DataDescriptor server) {
        DataDescriptor desc;
        ArrayList<DatasetDesc> existing = new ArrayList<DatasetDesc>();
        if (server != null) {
            for (DatasetDesc dd : server.datasets) {
                if (!dd.exists) continue;
                existing.add(dd.getLocalCopy());
            }
        }
        Array catalogLocations = new Array();
        catalogLocations.add((Object)Gdx.files.absolute(Settings.settings.data.location));
        Array catalogFiles = new Array();
        for (FileHandle catalogLocation : catalogLocations) {
            Array.ArrayIterator cfs = catalogLocation.list(pathname -> pathname.canRead() && pathname.isDirectory() && !pathname.getName().equals("default-data") && pathname.toPath().resolve("dataset.json").toFile().exists());
            for (Array.ArrayIterator fh : cfs) {
                FileHandle fhDescriptor = new FileHandle(fh.file().toPath().resolve("dataset.json").toFile());
                catalogFiles.add((Object)fhDescriptor);
            }
        }
        JsonReader reader = new JsonReader();
        ArrayList<DatasetType> types = new ArrayList<DatasetType>();
        ArrayList<DatasetDesc> datasets = new ArrayList<DatasetDesc>();
        for (FileHandle catalogFile : catalogFiles) {
            JsonValue val = reader.parse(catalogFile);
            Path path = Path.of(catalogFile.path(), new String[0]);
            DatasetDesc dd = null;
            Iterator it = existing.iterator();
            while (it.hasNext()) {
                DatasetDesc remote = (DatasetDesc)it.next();
                if (!remote.checkPath.equals(path)) continue;
                dd = remote;
                it.remove();
                break;
            }
            if (dd == null) {
                dd = new DatasetDesc(reader, val, catalogFile);
            }
            dd.catalogFile = catalogFile;
            dd.exists = true;
            dd.status = DatasetDesc.DatasetStatus.INSTALLED;
            datasets.add(dd);
        }
        datasets.addAll(existing);
        for (DatasetDesc dd : datasets) {
            if (dd.description == null) {
                dd.description = dd.checkPath.toString();
            }
            if (dd.name != null) continue;
            dd.name = dd.catalogFile.nameWithoutExtension();
        }
        HashMap<String, DatasetType> typeMap = new HashMap<String, DatasetType>();
        for (DatasetDesc dd : datasets) {
            DatasetType dt;
            if (typeMap.containsKey(dd.type)) {
                dt = (DatasetType)typeMap.get(dd.type);
            } else {
                dt = new DatasetType(dd.type);
                typeMap.put(dd.type, dt);
                types.add(dt);
            }
            dd.datasetType = dt;
            if (dd.minGsVersion >= 0 && (3061001 < dd.minGsVersion || dd.minGsVersion < 3030100)) continue;
            dt.datasets.add(dd);
        }
        Comparator<DatasetType> byType = Comparator.comparing(datasetType -> DatasetManagerWindow.getTypeWeight(datasetType.typeStr));
        types.sort(byType);
        DataDescriptor.localDataDescriptor = desc = new DataDescriptor(types, datasets);
        return desc;
    }

    static {
        specialDirectories = Set.of("tmp", "cache");
    }
}

