/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.datadesc;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.JsonReader;
import com.badlogic.gdx.utils.JsonValue;
import gaiasky.util.GlobalResources;
import gaiasky.util.Logger;
import gaiasky.util.Settings;
import gaiasky.util.TextUtils;
import gaiasky.util.datadesc.DatasetType;
import gaiasky.util.i18n.I18n;
import gaiasky.util.update.VersionChecker;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Locale;

public class DatasetDesc {
    private final Logger.Log logger = Logger.getLogger(DatasetDesc.class);
    public JsonValue source;
    public String key;
    public String name;
    public String description;
    public String[] links;
    public String[] credits;
    public String creator;
    public String type;
    public String file;
    public DatasetType datasetType;
    public DatasetStatus status;
    public Path checkPath;
    public String checkStr;
    public FileHandle catalogFile;
    public String size;
    public long sizeBytes;
    public String nObjectsStr;
    public long nObjects;
    public String sha256;
    public boolean exists;
    public int myVersion = -1;
    public int serverVersion;
    public int minGsVersion = -1;
    public boolean outdated;
    public boolean baseData;
    public String releaseNotes;
    public String[] files;
    public DatasetDesc server;
    private JsonReader reader;

    public DatasetDesc() {
    }

    public DatasetDesc(JsonReader reader, JsonValue source) {
        this(reader, source, null);
    }

    public DatasetDesc(JsonReader reader, JsonValue source, FileHandle localCatalogFile) {
        this.reader = reader;
        this.source = source;
        if (source.has("check")) {
            this.checkStr = source.getString("check");
            if (!this.checkStr.startsWith("$data/")) {
                this.checkStr = "$data/" + this.checkStr;
            }
            this.checkPath = Settings.settings.data.dataPath(this.checkStr);
            this.exists = Files.exists(this.checkPath, new LinkOption[0]) && Files.isReadable(this.checkPath);
            this.serverVersion = source.getInt("version", 0);
            if (this.exists) {
                this.myVersion = this.checkJsonVersion(this.checkPath);
                this.outdated = this.serverVersion > this.myVersion;
            } else {
                this.outdated = false;
            }
        } else if (localCatalogFile != null) {
            this.checkPath = localCatalogFile.file().toPath();
            Path dataLocation = Path.of(Settings.settings.data.location, new String[0]);
            String relative = dataLocation.toUri().relativize(this.checkPath.toUri()).getPath();
            this.checkStr = "$data/" + relative;
            this.exists = localCatalogFile.exists();
        }
        this.status = this.exists ? DatasetStatus.INSTALLED : DatasetStatus.AVAILABLE;
        boolean hasKey = source.has("key");
        if (hasKey) {
            this.key = source.getString("key");
        }
        boolean bl = hasKey = hasKey || localCatalogFile != null;
        if (source.has("name")) {
            this.name = source.getString("name");
        }
        if (this.key == null && this.name != null) {
            this.key = this.name.replaceAll("\\s+", "-");
        }
        if (this.key != null) {
            this.baseData = this.key.equals("default-data");
        }
        if (source.has("version") && this.myVersion == -1) {
            this.myVersion = source.getInt("version");
        }
        if (source.has("mingsversion")) {
            this.minGsVersion = VersionChecker.correctVersionNumber(source.getInt("mingsversion"));
        }
        if (source.has("file")) {
            this.file = source.getString("file");
        }
        if (source.has("description")) {
            this.description = source.getString("description");
            if (!hasKey && this.description.contains("-")) {
                this.name = this.description.substring(0, this.description.indexOf("-")).trim();
                this.description = this.description.substring(this.description.indexOf("-") + 1).trim();
            }
            this.description = TextUtils.unescape(this.description);
        }
        this.releaseNotes = source.has("releasenotes") ? TextUtils.unescape(source.getString("releasenotes")) : null;
        JsonValue links = null;
        if (source.has("links")) {
            links = source.get("links");
        } else if (source.has("link")) {
            links = source.get("link");
        }
        if (links != null) {
            if (links.isArray()) {
                this.links = links.asStringArray();
            } else if (links.isString()) {
                this.links = new String[]{links.asString()};
            } else {
                this.logger.warn("Attribute credits must be a String or String[].");
            }
        } else {
            this.links = null;
        }
        this.creator = source.has("creator") ? source.getString("creator") : null;
        if (source.has("credits")) {
            JsonValue c = source.get("credits");
            if (c.isArray()) {
                this.credits = c.asStringArray();
            } else if (c.isString()) {
                this.credits = new String[]{c.asString()};
            } else {
                this.logger.warn("Attribute credits must be a String or String[].");
            }
        } else {
            this.credits = null;
        }
        this.type = source.has("type") ? source.getString("type") : "other";
        try {
            this.sizeBytes = source.getLong("size");
            this.size = GlobalResources.humanReadableByteCount(this.sizeBytes, true);
        }
        catch (IllegalArgumentException e) {
            this.sizeBytes = -1L;
            this.size = "?";
        }
        try {
            this.nObjects = source.getLong("nobjects");
            this.nObjectsStr = I18n.msg("gui.dataset.nobjects", GlobalResources.nObjectsToString(this.nObjects));
        }
        catch (IllegalArgumentException e) {
            this.nObjects = -1L;
            this.nObjectsStr = "N/A";
        }
        this.sha256 = source.has("sha256") ? source.getString("sha256") : null;
        JsonValue dataFiles = null;
        if (source.has("files")) {
            dataFiles = source.get("files");
        } else if (source.has("data") && source.get("data").isArray()) {
            dataFiles = source.get("data");
        }
        if (dataFiles != null) {
            try {
                this.files = dataFiles.asStringArray();
                for (int i = 0; i < this.files.length; ++i) {
                    this.files[i] = Settings.settings.data.dataFile(this.files[i]);
                }
            }
            catch (Exception exception) {}
        } else {
            this.files = null;
        }
    }

    private int checkJsonVersion(Path path) throws RuntimeException {
        if (path != null) {
            JsonValue jf;
            String fname;
            String extension;
            File file = path.toFile();
            if (file.exists() && file.canRead() && file.isFile() && (extension = (fname = file.getName()).substring(fname.lastIndexOf(".") + 1)).equalsIgnoreCase("json") && (jf = this.reader.parse(Gdx.files.absolute(file.getAbsolutePath()))).has("version")) {
                try {
                    return jf.getInt("version", 0);
                }
                catch (Exception e) {
                    this.logger.error(e, "The 'version' attribute must be an integer: " + String.valueOf(path));
                }
            }
            return 0;
        }
        throw new RuntimeException("Path is null");
    }

    public boolean filter(String filterText) {
        if (filterText != null) {
            return (filterText = filterText.toLowerCase(Locale.ROOT)).isBlank() || this.name != null && this.name.toLowerCase(Locale.ROOT).contains(filterText) || this.description != null && this.description.toLowerCase(Locale.ROOT).contains(filterText) || this.key != null && this.key.toLowerCase(Locale.ROOT).contains(filterText) || this.type != null && this.type.toLowerCase(Locale.ROOT).contains(filterText);
        }
        return true;
    }

    public boolean isStarDataset() {
        return this.type != null && (this.type.equals("catalog-lod") || this.type.equals("catalog-gaia") || this.type.equals("catalog-star"));
    }

    public DatasetDesc getLocalCopy() {
        DatasetDesc copy = this.copy();
        copy.catalogFile = Gdx.files.absolute(copy.checkPath.toAbsolutePath().toString());
        return copy;
    }

    public DatasetDesc copy() {
        DatasetDesc copy = new DatasetDesc();
        copy.reader = this.reader;
        copy.source = this.source;
        copy.key = this.key;
        copy.name = this.name;
        copy.description = this.description;
        copy.links = this.links;
        copy.creator = this.creator;
        copy.credits = this.credits;
        copy.type = this.type;
        copy.file = this.file;
        copy.datasetType = this.datasetType;
        copy.status = this.status;
        copy.checkStr = this.checkStr;
        copy.checkPath = this.checkPath;
        copy.catalogFile = this.catalogFile;
        copy.size = this.size;
        copy.sizeBytes = this.sizeBytes;
        copy.nObjectsStr = this.nObjectsStr;
        copy.nObjects = this.nObjects;
        copy.sha256 = this.sha256;
        copy.exists = this.exists;
        copy.myVersion = this.myVersion;
        copy.serverVersion = this.serverVersion;
        copy.minGsVersion = this.minGsVersion;
        copy.outdated = this.outdated;
        copy.baseData = this.baseData;
        copy.releaseNotes = this.releaseNotes;
        copy.files = this.files;
        copy.server = this.server;
        return copy;
    }

    public static enum DatasetStatus {
        AVAILABLE,
        INSTALLED,
        DOWNLOADING;

    }
}

