/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.datadesc;

import com.badlogic.gdx.utils.Array;
import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.util.Logger;
import gaiasky.util.Settings;
import gaiasky.util.SysUtils;
import gaiasky.util.datadesc.DatasetDesc;
import gaiasky.util.i18n.I18n;
import gaiasky.util.io.FileInfoInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.util.List;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import org.kamranzafar.jtar.TarEntry;
import org.kamranzafar.jtar.TarInputStream;

public class DatasetDownloadUtils {
    private static final Logger.Log logger = Logger.getLogger(DatasetDownloadUtils.class);
    private static final DatasetDownloadUtils instance = new DatasetDownloadUtils();
    private static final DecimalFormat nf = new DecimalFormat("##0.0");

    public static long fileSize(String inputFilePath) {
        return new File(inputFilePath).length();
    }

    public static long fileSizeGZUncompressed(String inputFilePath) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(inputFilePath, "r");
        raf.seek(raf.length() - 4L);
        byte[] bytes = new byte[4];
        raf.read(bytes);
        long fileSize = ByteBuffer.wrap(bytes).order(ByteOrder.nativeOrder()).getLong();
        if (fileSize < 0L) {
            fileSize += 0x100000000L;
        }
        raf.close();
        return fileSize;
    }

    public static void cleanupTempFiles() {
        DatasetDownloadUtils.cleanupTempFiles(true, false);
    }

    public static void cleanupTempFile(String file) {
        DatasetDownloadUtils.deleteFile(Path.of(file, new String[0]));
    }

    public static void cleanupTempFiles(boolean dataDownloads, boolean dataDescriptor) {
        if (dataDownloads) {
            Path tempDir = SysUtils.getDataTempDir(Settings.settings.data.location);
            try (Stream<Path> stream = Files.find(tempDir, 2, (path, basicFileAttributes) -> {
                File file = path.toFile();
                return !file.isDirectory() && file.getName().endsWith("tar.gz.part");
            }, new FileVisitOption[0]);){
                stream.forEach(DatasetDownloadUtils::deleteFile);
            }
            catch (IOException e) {
                logger.error(e);
            }
        }
        if (dataDescriptor) {
            Path gsDownload = SysUtils.getDataTempDir(Settings.settings.data.location).resolve("gaiasky-data.json");
            DatasetDownloadUtils.deleteFile(gsDownload);
        }
    }

    public static void deleteFile(Path p) {
        if (Files.exists(p, new LinkOption[0])) {
            try {
                Files.delete(p);
            }
            catch (IOException e) {
                logger.error(e, "Failed cleaning up file: " + String.valueOf(p));
            }
        }
    }

    public static void decompress(String in, File out, DatasetDesc dataset) throws Exception {
        TarEntry entry;
        FileInfoInputStream fIs = new FileInfoInputStream(in);
        GZIPInputStream gzIs = new GZIPInputStream(fIs);
        TarInputStream tarIs = new TarInputStream((InputStream)gzIs);
        double sizeKb = (double)DatasetDownloadUtils.fileSize(in) / 1000.0;
        String sizeKbStr = nf.format(sizeKb);
        long last = 0L;
        boolean error = false;
        IOException errorException = null;
        Array processedFiles = new Array();
        while (null != (entry = tarIs.getNextEntry())) {
            if (entry.isDirectory()) continue;
            File curFile = new File(out, entry.getName());
            File parent = curFile.getParentFile();
            if (!parent.exists() && !parent.mkdirs()) {
                logger.info("Parent directory not created, already exists: " + String.valueOf(parent.toPath()));
            }
            try (FileOutputStream fos = new FileOutputStream(curFile);
                 BufferedOutputStream dest = new BufferedOutputStream(fos);){
                int count;
                processedFiles.add((Object)curFile);
                byte[] data = new byte[2048];
                while ((count = tarIs.read(data)) != -1) {
                    dest.write(data, 0, count);
                }
            }
            catch (IOException e) {
                errorException = e;
                error = true;
                break;
            }
            long current = System.currentTimeMillis();
            long elapsed = current - last;
            if (elapsed <= 250L) continue;
            GaiaSky.postRunnable(() -> {
                float val = (float)((double)fIs.getBytesRead() / 1000.0 / sizeKb) * 100.0f;
                String progressString = I18n.msg("gui.download.extracting", nf.format((double)fIs.getBytesRead() / 1000.0) + "/" + sizeKbStr + " Kb");
                EventManager.publish(Event.DATASET_DOWNLOAD_PROGRESS_INFO, instance, dataset.key, Float.valueOf(val), progressString, null);
            });
            last = current;
        }
        if (error) {
            String msg = I18n.msg("gui.download.extracting.error", errorException);
            logger.error(errorException, msg);
            EventManager.publish(Event.POST_POPUP_NOTIFICATION, instance, msg, Float.valueOf(-1.0f));
            for (File f : processedFiles) {
                DatasetDownloadUtils.deleteFile(f.toPath());
            }
        }
    }

    public static boolean isEnabled(DatasetDesc dataset) {
        return DatasetDownloadUtils.isPathIn(Settings.settings.data.dataFile(dataset.checkStr), Settings.settings.data.dataFiles);
    }

    public static boolean isPathIn(String path, List<String> setting) {
        for (String candidate : setting) {
            Path candidatePath = Settings.settings.data.dataPath(candidate);
            try {
                if (!Path.of(path, new String[0]).toRealPath(new LinkOption[0]).equals(candidatePath.toRealPath(new LinkOption[0]))) continue;
                return true;
            }
            catch (IOException e) {
                logger.error(e);
            }
        }
        return false;
    }
}

