/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.ds;

import gaiasky.util.Logger;
import gaiasky.util.Settings;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.jafama.FastMath;

public class GaiaSkyExecutorService {
    private static final Logger.Log logger = Logger.getLogger(GaiaSkyExecutorService.class);
    private ThreadPoolExecutor pool;
    private BlockingQueue<Runnable> workQueue;

    public GaiaSkyExecutorService() {
        this.initialize();
    }

    public void initialize() {
        this.workQueue = new LinkedBlockingQueue<Runnable>();
        int nThreads = !Settings.settings.performance.multithreading ? 1 : FastMath.max((int)1, (int)Settings.settings.performance.getNumberOfThreads());
        this.pool = new ThreadPoolExecutor(nThreads, nThreads, 0L, TimeUnit.SECONDS, this.workQueue);
        this.pool.setThreadFactory(new DaemonThreadFactory());
    }

    public boolean execute(Runnable r) {
        if (this.pool != null && !this.pool.isShutdown() && !this.inQueue(r)) {
            this.pool.execute(r);
            return true;
        }
        return false;
    }

    public ThreadPoolExecutor getPool() {
        return this.pool;
    }

    public boolean inQueue(Runnable task) {
        return this.workQueue != null && this.workQueue.contains(task);
    }

    public void shutDownThreadPool() {
        if (this.pool != null && !this.pool.isShutdown()) {
            this.pool.shutdown();
            try {
                if (!this.pool.awaitTermination(500L, TimeUnit.MILLISECONDS)) {
                    logger.debug("Timeout elapsed while waiting for the pool to shut down");
                }
            }
            catch (Exception e) {
                logger.error(e);
            }
        }
        if (this.workQueue != null) {
            this.workQueue.clear();
        }
    }

    private static class DaemonThreadFactory
    implements ThreadFactory {
        private int sequence = 0;

        private DaemonThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, "gaiasky-worker-" + this.sequence);
            ++this.sequence;
            t.setDaemon(true);
            return t;
        }
    }
}

