/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.filter;

import com.badlogic.gdx.utils.Array;
import gaiasky.scene.api.IParticleRecord;
import gaiasky.util.filter.FilterRule;
import java.util.Locale;

public class Filter {
    private final Array<FilterRule> rules;
    private IOperation operation;

    public Filter(FilterRule rule) {
        this.rules = new Array();
        this.rules.add((Object)rule);
        this.operation = new OperationAnd();
    }

    public Filter(String operation, FilterRule ... rules) {
        this.rules = new Array((Object[])rules);
        this.operation = this.getOperationFromString(operation);
    }

    public Filter(String operation, Array<FilterRule> rules) {
        this.rules = rules;
        this.operation = this.getOperationFromString(operation);
    }

    public Filter deepCopy() {
        Array rulesCopy = new Array(false, this.rules.size);
        for (int i = 0; i < this.rules.size; ++i) {
            rulesCopy.add((Object)((FilterRule)this.rules.get(i)).copy());
        }
        return new Filter(this.operation.getOperationString(), (Array<FilterRule>)rulesCopy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean evaluate(IParticleRecord pb) {
        Filter filter = this;
        synchronized (filter) {
            return this.operation.evaluate(this.rules, pb);
        }
    }

    public boolean hasRules() {
        return this.rules != null && this.rules.size > 0;
    }

    public Array<FilterRule> getRules() {
        return this.rules;
    }

    public IOperation getOperation() {
        return this.operation;
    }

    public void setOperation(String op) {
        this.operation = this.getOperationFromString(op);
    }

    public String getOperationString() {
        return this.operation != null ? this.operation.getOperationString() : null;
    }

    public IOperation getOperationFromString(String op) {
        return switch (op.toLowerCase(Locale.ROOT)) {
            case "or" -> new OperationOr();
            case "xor" -> new OperationXor();
            default -> new OperationAnd();
        };
    }

    public void addRule(FilterRule rule) {
        this.rules.add((Object)rule);
    }

    public boolean removeRule(FilterRule rule) {
        return this.rules.removeValue((Object)rule, true);
    }

    public static class OperationAnd
    implements IOperation {
        public String op = "and";

        @Override
        public boolean evaluate(Array<FilterRule> rules, IParticleRecord bean) {
            boolean result = true;
            for (FilterRule rule : rules) {
                result = result && rule.evaluate(bean);
            }
            return result;
        }

        @Override
        public String getOperationString() {
            return this.op;
        }
    }

    public static interface IOperation {
        public boolean evaluate(Array<FilterRule> var1, IParticleRecord var2);

        public String getOperationString();
    }

    public static class OperationOr
    implements IOperation {
        public String op = "or";

        @Override
        public boolean evaluate(Array<FilterRule> rules, IParticleRecord bean) {
            boolean result = false;
            for (FilterRule rule : rules) {
                result = result || rule.evaluate(bean);
            }
            return result;
        }

        @Override
        public String getOperationString() {
            return this.op;
        }
    }

    public static class OperationXor
    implements IOperation {
        public String op = "xor";

        @Override
        public boolean evaluate(Array<FilterRule> rules, IParticleRecord bean) {
            boolean result = false;
            for (FilterRule rule : rules) {
                result ^= rule.evaluate(bean);
            }
            return result;
        }

        @Override
        public String getOperationString() {
            return this.op;
        }
    }
}

