/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.filter;

import gaiasky.scene.api.IParticleRecord;
import gaiasky.util.filter.attrib.IAttribute;
import gaiasky.util.parse.Parser;
import java.util.Comparator;

public class FilterRule {
    private static final Comparator<String> stringComparator = String::compareTo;
    private Object value;
    private IComparator comparator;
    private IAttribute attribute;

    public FilterRule(String comp, IAttribute attr, Object val) {
        this.attribute = attr;
        this.value = val;
        this.comparator = this.getComparatorFromString(comp);
    }

    public boolean evaluate(IParticleRecord bean) {
        return this.comparator.evaluate(this.attribute.get(bean), this.value);
    }

    public FilterRule copy() {
        return new FilterRule(this.comparator.toString(), this.attribute, this.value);
    }

    public Object getValue() {
        return this.value;
    }

    public double getDoubleValue() {
        Object object = this.value;
        if (object instanceof Number) {
            Number n = (Number)object;
            return n.doubleValue();
        }
        return Double.NaN;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public IComparator getComparator() {
        return this.comparator;
    }

    public void setComparator(IComparator comp) {
        this.comparator = comp;
    }

    public IAttribute getAttribute() {
        return this.attribute;
    }

    public void setAttribute(IAttribute attr) {
        this.attribute = attr;
    }

    public IComparator getComparatorFromString(String c) {
        return switch (c) {
            default -> new ComparatorG();
            case ">=" -> new ComparatorGeq();
            case "<" -> new ComparatorL();
            case "<=" -> new ComparatorLeq();
            case "==" -> new ComparatorEq();
            case "!=" -> new ComparatorNeq();
        };
    }

    public static interface IComparator {
        public boolean evaluate(Object var1, Object var2);

        public String toString();
    }

    public static class ComparatorG
    implements IComparator {
        @Override
        public boolean evaluate(Object val1, Object val2) {
            if (val1 instanceof Number) {
                Number n1 = (Number)val1;
                if (val2 instanceof Number) {
                    Number n2 = (Number)val2;
                    return n1.doubleValue() > n2.doubleValue();
                }
            }
            if (val1 instanceof String) {
                String s1 = (String)val1;
                if (val2 instanceof String) {
                    String s2 = (String)val2;
                    return stringComparator.compare(s1, s2) >= 0;
                }
            }
            if (val1 instanceof String) {
                String s = (String)val1;
                if (val2 instanceof Number) {
                    Number n = (Number)val2;
                    try {
                        return Parser.parseDoubleException(s) > n.doubleValue();
                    }
                    catch (Exception e) {
                        return false;
                    }
                }
            }
            return false;
        }

        @Override
        public String toString() {
            return ">";
        }
    }

    public static class ComparatorGeq
    implements IComparator {
        @Override
        public boolean evaluate(Object val1, Object val2) {
            if (val1 instanceof Number) {
                Number n1 = (Number)val1;
                if (val2 instanceof Number) {
                    Number n2 = (Number)val2;
                    return n1.doubleValue() >= n2.doubleValue();
                }
            }
            if (val1 instanceof String) {
                String s1 = (String)val1;
                if (val2 instanceof String) {
                    String s2 = (String)val2;
                    return stringComparator.compare(s1, s2) >= 0;
                }
            }
            if (val1 instanceof String) {
                String s = (String)val1;
                if (val2 instanceof Number) {
                    Number n = (Number)val2;
                    try {
                        return Parser.parseDoubleException(s) >= n.doubleValue();
                    }
                    catch (Exception e) {
                        return false;
                    }
                }
            }
            return false;
        }

        @Override
        public String toString() {
            return ">=";
        }
    }

    public static class ComparatorL
    implements IComparator {
        @Override
        public boolean evaluate(Object val1, Object val2) {
            if (val1 instanceof Number) {
                Number n1 = (Number)val1;
                if (val2 instanceof Number) {
                    Number n2 = (Number)val2;
                    return n1.doubleValue() < n2.doubleValue();
                }
            }
            if (val1 instanceof String) {
                String s1 = (String)val1;
                if (val2 instanceof String) {
                    String s2 = (String)val2;
                    return stringComparator.compare(s1, s2) < 0;
                }
            }
            if (val1 instanceof String) {
                String s = (String)val1;
                if (val2 instanceof Number) {
                    Number n = (Number)val2;
                    try {
                        return Parser.parseDoubleException(s) < n.doubleValue();
                    }
                    catch (Exception e) {
                        return false;
                    }
                }
            }
            return false;
        }

        @Override
        public String toString() {
            return "<";
        }
    }

    public static class ComparatorLeq
    implements IComparator {
        @Override
        public boolean evaluate(Object val1, Object val2) {
            if (val1 instanceof Number) {
                Number n1 = (Number)val1;
                if (val2 instanceof Number) {
                    Number n2 = (Number)val2;
                    return n1.doubleValue() <= n2.doubleValue();
                }
            }
            if (val1 instanceof String) {
                String s1 = (String)val1;
                if (val2 instanceof String) {
                    String s2 = (String)val2;
                    return stringComparator.compare(s1, s2) <= 0;
                }
            }
            if (val1 instanceof String) {
                String s = (String)val1;
                if (val2 instanceof Number) {
                    Number n = (Number)val2;
                    try {
                        return Parser.parseDoubleException(s) <= n.doubleValue();
                    }
                    catch (Exception e) {
                        return false;
                    }
                }
            }
            return false;
        }

        @Override
        public String toString() {
            return "<=";
        }
    }

    public static class ComparatorEq
    implements IComparator {
        @Override
        public boolean evaluate(Object val1, Object val2) {
            if (val1 instanceof Number) {
                Number n1 = (Number)val1;
                if (val2 instanceof Number) {
                    Number n2 = (Number)val2;
                    return n1.doubleValue() == n2.doubleValue();
                }
            }
            if (val1 instanceof String) {
                String s1 = (String)val1;
                if (val2 instanceof String) {
                    String s2 = (String)val2;
                    return s1.equalsIgnoreCase(s2);
                }
            }
            if (val1 instanceof String) {
                String s = (String)val1;
                if (val2 instanceof Number) {
                    Number n = (Number)val2;
                    try {
                        return Parser.parseDoubleException(s) == n.doubleValue();
                    }
                    catch (Exception e) {
                        return false;
                    }
                }
            }
            return false;
        }

        @Override
        public String toString() {
            return "==";
        }
    }

    public static class ComparatorNeq
    implements IComparator {
        @Override
        public boolean evaluate(Object val1, Object val2) {
            if (val1 instanceof Number) {
                Number n1 = (Number)val1;
                if (val2 instanceof Number) {
                    Number n2 = (Number)val2;
                    return n1.doubleValue() != n2.doubleValue();
                }
            }
            if (val1 instanceof String) {
                String s1 = (String)val1;
                if (val2 instanceof String) {
                    String s2 = (String)val2;
                    return !s1.equalsIgnoreCase(s2);
                }
            }
            if (val1 instanceof String) {
                String s = (String)val1;
                if (val2 instanceof Number) {
                    Number n = (Number)val2;
                    try {
                        return Parser.parseDoubleException(s) != n.doubleValue();
                    }
                    catch (Exception e) {
                        return false;
                    }
                }
            }
            return false;
        }

        @Override
        public String toString() {
            return "!=";
        }
    }
}

