/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gaia;

import gaiasky.util.coord.AstroUtils;
import gaiasky.util.coord.Coordinates;
import gaiasky.util.coord.NslSun;
import gaiasky.util.gaia.BaseAttitudeDataServer;
import gaiasky.util.gaia.IAttitude;
import gaiasky.util.gaia.Satellite;
import gaiasky.util.math.Vector3D;
import net.jafama.FastMath;

public abstract class AnalyticalAttitudeDataServer
extends BaseAttitudeDataServer<IAttitude> {
    protected static final double PI = Math.PI;
    protected static final double TWO_PI = Math.PI * 2;
    protected static final double FOUR_PI = Math.PI * 4;
    protected static final double PI_HALF = 1.5707963267948966;
    protected static final double ARCSEC_PER_S_TO_DEG_PER_DAY = 24.0;
    protected static final Vector3D X_AXIS = Vector3D.getUnitX();
    protected static final Vector3D Y_AXIS = Vector3D.getUnitY();
    protected static final Vector3D Z_AXIS = Vector3D.getUnitZ();
    protected static final double OBLIQUITY_RAD = Coordinates.OBLIQUITY_RAD_J2000;
    protected static final double OBLIQUITY_DEG = 23.4392808;
    protected long targetScanPeriod = FastMath.round((double)(1.296E15 / Satellite.SCANRATE));
    protected NslSun nslSun = new NslSun();
    private long tRef;
    private double xiRef;
    private double nuRef;
    private double omegaRef;
    private double targetPrecessionRate;

    public void setDefault() {
        this.setRefTime((long)(AstroUtils.JD_J2010 * 8.64E13));
        this.setXiRef(Math.toRadians(Satellite.SOLARASPECTANGLE_NOMINAL));
        this.setNuRef(Satellite.REVOLVINGPHASE_INITIAL);
        this.setOmegaRef(Satellite.SCANPHASE_INITIAL);
        this.setTargetScanRate(Satellite.SCANRATE);
        this.setTargetPrecessionRate(Satellite.SPINAXIS_NUMBEROFLOOPSPERYEAR);
    }

    public long getTargetScanPeriod() {
        return this.targetScanPeriod;
    }

    public void setTargetScanPeriod(long targetScanPeriod) {
        this.targetScanPeriod = targetScanPeriod;
        this.initialized = false;
    }

    public double getTargetScanRate() {
        return 1.296E15 / (double)this.targetScanPeriod;
    }

    public void setTargetScanRate(double targetScanRate) {
        this.targetScanPeriod = FastMath.round((double)(1.296E15 / targetScanRate));
        this.initialized = false;
    }

    public double getXiRef() {
        return this.xiRef;
    }

    public void setXiRef(double xiRef) {
        this.xiRef = xiRef;
        this.initialized = false;
    }

    public double getNuRef() {
        return this.nuRef;
    }

    public void setNuRef(double nuRef) {
        this.nuRef = nuRef;
        this.initialized = false;
    }

    public double getOmegaRef() {
        return this.omegaRef;
    }

    public void setOmegaRef(double omegaRef) {
        this.omegaRef = omegaRef;
        this.initialized = false;
    }

    public double getTargetPrecessionRate() {
        return this.targetPrecessionRate;
    }

    public void setTargetPrecessionRate(double targetPrecessionRate) {
        this.targetPrecessionRate = targetPrecessionRate;
        this.initialized = false;
    }

    public boolean inGap(long time) {
        return false;
    }

    @Override
    public long getRefTime() {
        return this.tRef;
    }

    @Override
    public void setRefTime(long tRef) {
        this.tRef = tRef;
    }

    protected NslSun getNominalSunVector() {
        return this.nslSun;
    }
}

