/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gaia;

import gaiasky.util.coord.Coordinates;
import gaiasky.util.coord.NslSun;
import gaiasky.util.gaia.HeliotropicAnglesRates;
import gaiasky.util.gaia.IAttitude;
import gaiasky.util.math.QuaternionDouble;
import gaiasky.util.math.Vector3D;
import net.jafama.FastMath;

public class AttitudeConverter {
    static final double PI = Math.PI;
    static final double PI_HALF = 1.5707963267948966;
    static final Vector3D X_AXIS = Vector3D.getUnitX();
    static final Vector3D Y_AXIS = Vector3D.getUnitY();
    static final Vector3D Z_AXIS = Vector3D.getUnitZ();
    static final Vector3D aux1 = new Vector3D();
    static final Vector3D aux2 = new Vector3D();
    static final Vector3D aux3 = new Vector3D();
    static final double OBLIQUITY = Coordinates.OBLIQUITY_RAD_J2000;
    static final double OBLIQUITY_DEG = 23.4392808;
    static final double sinObliquity = FastMath.sin((double)OBLIQUITY);
    static final double cosObliquity = FastMath.cos((double)OBLIQUITY);
    static final Vector3D[] xyz = new Vector3D[]{new Vector3D(), new Vector3D(), new Vector3D()};

    public static QuaternionDouble[] heliotropicToQuaternions(double lSun, double xi, double nu, double omega, double lSunDot, double nuDot, double omegaDot) {
        QuaternionDouble q = new QuaternionDouble(Z_AXIS, 23.4392808);
        q.mul(new QuaternionDouble(Y_AXIS, FastMath.toDegrees((double)lSun)));
        q.mul(new QuaternionDouble(Z_AXIS, FastMath.toDegrees((double)(nu - 1.5707963267948966))));
        q.mul(new QuaternionDouble(X_AXIS, FastMath.toDegrees((double)(1.5707963267948966 - xi))));
        q.mul(new QuaternionDouble(Y_AXIS, FastMath.toDegrees((double)omega)));
        double sinLSun = FastMath.sin((double)lSun);
        double cosLSun = FastMath.cos((double)lSun);
        Vector3D zInSrs = aux1;
        zInSrs.set(Y_AXIS).rotateVectorByQuaternion(q);
        double rateX = nuDot * cosLSun + omegaDot * zInSrs.x;
        double rateY = -lSunDot * sinObliquity + nuDot * sinLSun * cosObliquity + omegaDot * zInSrs.y;
        double rateZ = lSunDot * cosObliquity + nuDot * sinLSun * sinObliquity + omegaDot * zInSrs.z;
        QuaternionDouble halfSpinInIcrs = new QuaternionDouble(0.5 * rateZ, 0.5 * rateX, 0.5 * rateY, 0.0);
        QuaternionDouble qDot = halfSpinInIcrs.mul(q);
        return new QuaternionDouble[]{q, qDot};
    }

    public static double[] heliotropicToQuaternionSrsRates(double lSun, double xi, double nu, double omega, double lSunDot, double nuDot, double omegaDot) {
        QuaternionDouble q = new QuaternionDouble(Z_AXIS, 23.4392808);
        q.mul(new QuaternionDouble(Y_AXIS, FastMath.toDegrees((double)lSun)));
        q.mul(new QuaternionDouble(Z_AXIS, FastMath.toDegrees((double)(nu - 1.5707963267948966))));
        q.mul(new QuaternionDouble(X_AXIS, FastMath.toDegrees((double)(1.5707963267948966 - xi))));
        q.mul(new QuaternionDouble(Y_AXIS, FastMath.toDegrees((double)omega)));
        Vector3D k = new Vector3D(0.0, -sinObliquity, cosObliquity);
        k.mul(q);
        double sinLSun = FastMath.sin((double)lSun);
        double cosLSun = FastMath.cos((double)lSun);
        Vector3D sun = new Vector3D(cosLSun, cosObliquity * sinLSun, sinObliquity * sinLSun);
        sun.mul(q);
        double rateX = k.x * lSunDot + sun.x * nuDot;
        double rateY = k.y * lSunDot + sun.y * nuDot;
        double rateZ = k.z * lSunDot + sun.z * nuDot + omegaDot;
        return new double[]{q.z, q.x, q.y, q.w, rateZ, rateX, rateY};
    }

    public static QuaternionDouble[] getQuaternionAndRate(long gt, HeliotropicAnglesRates h) {
        NslSun sun = new NslSun();
        sun.setTime(gt);
        double lSun = sun.getSolarLongitude();
        double lSunDot = sun.getSolarLongitudeDot();
        QuaternionDouble q = new QuaternionDouble(Z_AXIS, 23.4392808);
        q.mul(new QuaternionDouble(Y_AXIS, FastMath.toDegrees((double)lSun)));
        q.mul(new QuaternionDouble(Z_AXIS, FastMath.toDegrees((double)(h.getNu() - 1.5707963267948966))));
        q.mul(new QuaternionDouble(X_AXIS, FastMath.toDegrees((double)(1.5707963267948966 - h.getXi()))));
        q.mul(new QuaternionDouble(Y_AXIS, FastMath.toDegrees((double)h.getOmega())));
        double sinLSun = FastMath.sin((double)lSun);
        double cosLSun = FastMath.cos((double)lSun);
        Vector3D zInSrs = aux1;
        zInSrs.set(Y_AXIS).mul(q);
        Vector3D sz = aux2;
        sz.set(sun.getSolarDirection(aux3)).crs(zInSrs).nor();
        double rateX = h.getNuDot() * cosLSun + h.getOmegaDot() * zInSrs.x + h.getXiDot() * sz.x;
        double rateY = -lSunDot * sinObliquity + h.getNuDot() * sinLSun * cosObliquity + h.getOmegaDot() * zInSrs.y + h.getXiDot() * sz.y;
        double rateZ = lSunDot * cosObliquity + h.getNuDot() * sinLSun * sinObliquity + h.getOmegaDot() * zInSrs.z + h.getXiDot() * sz.z;
        QuaternionDouble halfSpinInIcrs = new QuaternionDouble(0.5 * rateZ, 0.5 * rateX, 0.5 * rateY, 0.0);
        QuaternionDouble qDot = halfSpinInIcrs.mul(q);
        return new QuaternionDouble[]{q, qDot};
    }

    public static HeliotropicAnglesRates getHeliotropicAnglesRates(long gt, IAttitude att) {
        HeliotropicAnglesRates anglesAndRates = new HeliotropicAnglesRates();
        Vector3D k = new Vector3D(0.0, -sinObliquity, cosObliquity);
        NslSun sun = new NslSun();
        sun.setTime(gt);
        double cosLSun = FastMath.cos((double)sun.getSolarLongitude());
        double sinLSun = FastMath.sin((double)sun.getSolarLongitude());
        Vector3D s = new Vector3D(cosLSun, sinLSun * cosObliquity, sinLSun * sinObliquity);
        att.getSrsAxes(xyz);
        Vector3D m = new Vector3D(s);
        m.crs(xyz[2]);
        double sinXi = m.len();
        double cosXi = s.dot(xyz[2]);
        anglesAndRates.setFirstAngle(Math.atan2(sinXi, cosXi));
        double sinXiCosNu = k.dot(m);
        double sinXiSinNu = k.dot(xyz[2]);
        anglesAndRates.setSecondAngle(Math.atan2(sinXiSinNu, sinXiCosNu));
        double sinXiCosOmega = -m.dot(xyz[1]);
        double sinXiSinOmega = -m.dot(xyz[0]);
        anglesAndRates.setThirdAngle(Math.atan2(sinXiSinOmega, sinXiCosOmega));
        Vector3D spin = att.getSpinVectorInIcrs();
        Vector3D spinHel = new Vector3D(spin);
        spinHel.add(k.scl(-sun.getSolarLongitudeDot()));
        double sSpinHel = s.dot(spinHel);
        double zSpinHel = xyz[2].dot(spinHel);
        double mSpinHel = m.dot(spinHel);
        anglesAndRates.setFirstRate(mSpinHel / sinXi);
        anglesAndRates.setSecondRate((sSpinHel - zSpinHel * cosXi) / (sinXi * sinXi));
        anglesAndRates.setThirdRate((zSpinHel - sSpinHel * cosXi) / (sinXi * sinXi));
        return anglesAndRates;
    }
}

