/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gaia;

import gaiasky.util.LruCacheLong;
import gaiasky.util.gaia.BaseAttitudeDataServer;
import gaiasky.util.gaia.IAttitude;
import java.time.Instant;
import java.util.Date;

public class AttitudeIntervalBean
implements Comparable<AttitudeIntervalBean> {
    public String name;
    public Instant activationTime;
    public String file;
    public BaseAttitudeDataServer<IAttitude> attitude;
    public LruCacheLong<IAttitude> cache;
    public long hits = 0L;
    public long misses = 0L;

    public AttitudeIntervalBean(String name, Instant activationTime, BaseAttitudeDataServer<IAttitude> attitude, String file) {
        this.file = file;
        this.name = name;
        this.activationTime = activationTime;
        this.attitude = attitude;
        this.cache = new LruCacheLong(10);
    }

    public synchronized IAttitude get(Date date) {
        return this.get(date.toInstant());
    }

    public synchronized IAttitude get(Instant instant) {
        long time = instant.toEpochMilli();
        if (!this.cache.containsKey(time)) {
            IAttitude att = this.attitude.getAttitude(instant);
            this.cache.put(time, att);
            ++this.misses;
            return att;
        }
        ++this.hits;
        return this.cache.get(time);
    }

    @Override
    public int compareTo(AttitudeIntervalBean o) {
        return this.activationTime.compareTo(o.activationTime);
    }

    public String toString() {
        return this.name;
    }
}

