/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gaia;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.XmlReader;
import gaiasky.util.BinarySearchTree;
import gaiasky.util.Logger;
import gaiasky.util.Settings;
import gaiasky.util.coord.AstroUtils;
import gaiasky.util.gaia.AttitudeIntervalBean;
import gaiasky.util.gaia.BaseAttitudeDataServer;
import gaiasky.util.gaia.Epsl;
import gaiasky.util.gaia.ModifiedScanningLaw;
import gaiasky.util.gaia.MslAttitudeDataServer;
import gaiasky.util.gaia.time.Duration;
import gaiasky.util.gaia.time.Hours;
import gaiasky.util.i18n.I18n;
import gaiasky.util.units.Quantity;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Stream;

public class AttitudeXmlParser {
    private static final Logger.Log logger = Logger.getLogger(AttitudeXmlParser.class);
    private static final Instant endOfMission;
    private static final DateTimeFormatter format;
    private static final DateTimeFormatter formatWithMs;

    public static BinarySearchTree<AttitudeIntervalBean> parseFolder(String folder) {
        Object object;
        block18: {
            Stream<Path> paths = Files.walk(Paths.get(Settings.settings.data.dataFile(folder), new String[0]), new FileVisitOption[0]);
            try {
                List<Path> ps = paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).toList();
                Array list = new Array(false, ps.size());
                for (Path p : ps) {
                    if (!p.toFile().getName().endsWith(".xml")) continue;
                    list.add((Object)new FileHandle(p.toFile()));
                }
                BinarySearchTree<AttitudeIntervalBean> bst = new BinarySearchTree<AttitudeIntervalBean>();
                TreeMap<Instant, FileHandle> datesMap = new TreeMap<Instant, FileHandle>();
                for (FileHandle fh : list) {
                    try {
                        Instant date = AttitudeXmlParser.parseActivationTime(fh);
                        datesMap.put(date, fh);
                    }
                    catch (Exception e) {
                        logger.error(e, I18n.msg("error.file.parse", fh.name()));
                    }
                }
                HashMap<FileHandle, Hours> durationMap = new HashMap<FileHandle, Hours>();
                Set dates = datesMap.keySet();
                FileHandle lastFH = null;
                Instant lastDate = null;
                for (Instant date : dates) {
                    if (lastDate != null && lastFH != null) {
                        long elapsed = date.toEpochMilli() - lastDate.toEpochMilli();
                        Hours d = new Hours((double)elapsed * 2.7777777777777776E-7);
                        durationMap.put(lastFH, d);
                    }
                    lastDate = date;
                    lastFH = (FileHandle)datesMap.get(date);
                }
                assert (lastDate != null);
                long elapsed = endOfMission.toEpochMilli() - lastDate.toEpochMilli();
                Hours d = new Hours((double)elapsed * 2.7777777777777776E-7);
                durationMap.put(lastFH, d);
                for (FileHandle fh : list) {
                    logger.info(I18n.msg("notif.attitude.loadingfile", fh.name()));
                    try {
                        AttitudeIntervalBean att = AttitudeXmlParser.parseFile(fh, (Duration)durationMap.get(fh), AttitudeXmlParser.findActivationDate(fh, datesMap));
                        bst.insert(att);
                    }
                    catch (Exception e) {
                        logger.error(e, I18n.msg("notif.error", e.getMessage()));
                    }
                }
                logger.info(I18n.msg("notif.attitude.initialized", list.size));
                object = bst;
                if (paths == null) break block18;
            }
            catch (Throwable throwable) {
                try {
                    if (paths != null) {
                        try {
                            paths.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    logger.error("Error loading attitude files");
                    return null;
                }
            }
            paths.close();
        }
        return object;
    }

    private static Instant findActivationDate(FileHandle fh, SortedMap<Instant, FileHandle> datesMap) {
        Set<Instant> keys = datesMap.keySet();
        for (Instant d : keys) {
            if (!((FileHandle)datesMap.get(d)).equals((Object)fh)) continue;
            return d;
        }
        return null;
    }

    private static Instant parseActivationTime(FileHandle fh) {
        XmlReader reader = new XmlReader();
        XmlReader.Element element = reader.parse(fh);
        XmlReader.Element model = element.getChildByName("model");
        String activTime = model.get("starttime");
        return AttitudeXmlParser.getDate(activTime);
    }

    private static AttitudeIntervalBean parseFile(FileHandle fh, Duration duration, Instant activationTime) {
        BaseAttitudeDataServer result = null;
        XmlReader reader = new XmlReader();
        XmlReader.Element element = reader.parse(fh);
        XmlReader.Element model = element.getChildByName("model");
        String name = model.get("name");
        String className = model.get("classname").replace("gaia.cu9.ari.gaiaorbit", "gaiasky");
        long startTimeNsSince2010 = (long)((AstroUtils.getJulianDate(activationTime) - AstroUtils.JD_J2010) * 8.64E13);
        XmlReader.Element scanlaw = model.getChildByName("scanlaw");
        String epochRef = scanlaw.getAttribute("epochref");
        Instant refEpochDate = AttitudeXmlParser.getDate(epochRef);
        long refEpochJ2010 = (long)((AstroUtils.getJulianDate(refEpochDate) - AstroUtils.JD_J2010) * 8.64E13);
        XmlReader.Element spinphase = scanlaw.getChildByName("spinphase");
        Quantity.Angle spinPhase = new Quantity.Angle((double)AttitudeXmlParser.getValueDouble(spinphase), spinphase.get("unit"));
        XmlReader.Element precessphase = scanlaw.getChildByName("precessphase");
        Quantity.Angle precessionPhase = new Quantity.Angle((double)AttitudeXmlParser.getValueDouble(precessphase), precessphase.get("unit"));
        XmlReader.Element precessrate = scanlaw.getChildByName("precessrate");
        double precessionRate = AttitudeXmlParser.getValueDouble(precessrate);
        XmlReader.Element scanrate = scanlaw.getChildByName("scanrate");
        Quantity.Angle scanRate = new Quantity.Angle((double)AttitudeXmlParser.getValueDouble(scanrate), scanrate.get("unit").split("_")[0]);
        XmlReader.Element saa = scanlaw.getChildByName("solaraspectangle");
        Quantity.Angle solarAspectAngle = new Quantity.Angle((double)AttitudeXmlParser.getValueDouble(saa), saa.get("unit"));
        if (className.contains("MslAttitudeDataServer")) {
            ModifiedScanningLaw msl = new ModifiedScanningLaw(startTimeNsSince2010);
            msl.setRefEpoch(refEpochJ2010);
            msl.setRefNu(precessionPhase.get(Quantity.Angle.AngleUnit.RAD));
            msl.setRefOmega(spinPhase.get(Quantity.Angle.AngleUnit.RAD));
            msl.setPrecRate(precessionRate);
            msl.setScanRate(scanRate.get(Quantity.Angle.AngleUnit.ARCSEC));
            msl.setRefXi(solarAspectAngle.get(Quantity.Angle.AngleUnit.RAD));
            msl.setTypicalHighDensityArea();
            msl.initialize();
            MslAttitudeDataServer mslDatServ = new MslAttitudeDataServer(startTimeNsSince2010, duration, msl);
            mslDatServ.initialize();
            result = mslDatServ;
        } else if (className.contains("Epsl")) {
            Epsl.Mode mode = name.equals("EPSL_F") ? Epsl.Mode.FOLLOWING : Epsl.Mode.PRECEDING;
            Epsl epsl = new Epsl(mode);
            epsl.setRefTime(refEpochJ2010);
            epsl.setNuRef(precessionPhase.get(Quantity.Angle.AngleUnit.RAD));
            epsl.setOmegaRef(spinPhase.get(Quantity.Angle.AngleUnit.RAD));
            epsl.setXiRef(solarAspectAngle.get(Quantity.Angle.AngleUnit.RAD));
            epsl.setTargetScanRate(scanRate.get(Quantity.Angle.AngleUnit.ARCSEC));
            epsl.setTargetPrecessionRate(precessionRate);
            result = epsl;
        }
        return new AttitudeIntervalBean(name, activationTime, result, fh.name());
    }

    private static Instant getDate(String date) {
        try {
            LocalDateTime ldt = LocalDateTime.parse(date, format);
            return ldt.toInstant(ZoneOffset.UTC);
        }
        catch (Exception e) {
            LocalDateTime ldt = LocalDateTime.parse(date, formatWithMs);
            return ldt.toInstant(ZoneOffset.UTC);
        }
    }

    private static Double getValueDouble(XmlReader.Element e) {
        return Double.parseDouble(e.get("value"));
    }

    static {
        format = DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm:ss").withLocale(I18n.locale).withZone(ZoneOffset.UTC);
        formatWithMs = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SS").withLocale(I18n.locale).withZone(ZoneOffset.UTC);
        endOfMission = AttitudeXmlParser.getDate("2026-09-14 17:44:20");
    }
}

