/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gaia;

import gaiasky.util.coord.AstroUtils;
import gaiasky.util.gaia.IAttitude;
import gaiasky.util.gaia.time.TimeContext;
import java.time.Instant;
import java.util.Date;

public abstract class BaseAttitudeDataServer<A extends IAttitude> {
    protected boolean initialized = false;
    protected TimeContext nativeTimeContext = null;
    protected TimeContext initialRequestedTimeContext = null;
    protected boolean withUncertaintiesCorrelations = true;
    private long refEpoch = -1L;

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public A getAttitude(Date date) {
        long tNs = (long)((AstroUtils.getJulianDateCache(date.toInstant()) - AstroUtils.JD_J2010) * 8.64E13);
        return this.getAttitudeNative(tNs);
    }

    public A getAttitude(Instant instant) {
        long tNs = (long)((AstroUtils.getJulianDateCache(instant) - AstroUtils.JD_J2010) * 8.64E13);
        return this.getAttitudeNative(tNs);
    }

    public synchronized A getAttitude(long time) {
        return this.getAttitudeNative(time);
    }

    protected abstract A getAttitudeNative(long var1);

    public long getRefTime() {
        return this.refEpoch;
    }

    public void setRefTime(long t) {
        this.refEpoch = t;
    }
}

