/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gaia;

import gaiasky.util.gaia.FOV;
import gaiasky.util.gaia.IAttitude;
import gaiasky.util.math.QuaternionDouble;
import gaiasky.util.math.Vector3D;
import net.jafama.FastMath;

public class ConcreteAttitude
implements IAttitude {
    private static final double BASICANGLE_DEGREE = 106.5;
    private static final Vector3D[] xyz = new Vector3D[]{new Vector3D(), new Vector3D(), new Vector3D()};
    private static final Vector3D[] fovDirections = new Vector3D[]{new Vector3D(), new Vector3D()};
    private static final Vector3D aux = new Vector3D();
    private final double halfGamma = FastMath.toRadians((double)53.25);
    private long t;
    private QuaternionDouble q;
    private QuaternionDouble qDot;

    public ConcreteAttitude(long t, QuaternionDouble q, boolean withZeroSigmaCorr) {
        this(t, q, null, withZeroSigmaCorr);
    }

    public ConcreteAttitude(long t, QuaternionDouble q, QuaternionDouble qDot, boolean withZeroSigmaCorr) {
        this.t = t;
        this.q = q;
        this.qDot = qDot;
    }

    @Override
    public long getTime() {
        return this.t;
    }

    public void setTime(long time) {
        this.t = time;
    }

    @Override
    public QuaternionDouble getQuaternion() {
        return this.q;
    }

    public void setQuaternion(QuaternionDouble q) {
        this.q = q;
    }

    @Override
    public QuaternionDouble getQuaternionDot() {
        return this.qDot;
    }

    public void setQuaternionDot(QuaternionDouble qDot) {
        this.qDot = qDot;
    }

    @Override
    public Vector3D getSpinVectorInSrs() {
        QuaternionDouble tmp = this.q.cpy();
        tmp.inverse().mul(this.qDot);
        return new Vector3D(2.0 * tmp.x, 2.0 * tmp.y, 2.0 * tmp.z);
    }

    @Override
    public Vector3D getSpinVectorInIcrs() {
        QuaternionDouble tmp = this.qDot.cpy();
        tmp.mulInverse(this.q);
        return new Vector3D(2.0 * tmp.x, 2.0 * tmp.y, 2.0 * tmp.z);
    }

    @Override
    public Vector3D[] getFovDirections() {
        double halfBasicAngle = 0.5 * FastMath.toRadians((double)106.5);
        this.getSrsAxes(xyz);
        Vector3D xScaled = xyz[0].scl(Math.cos(halfBasicAngle));
        Vector3D yScaled = xyz[1].scl(Math.sin(halfBasicAngle));
        fovDirections[0].set(xScaled).add(yScaled);
        fovDirections[1].set(xScaled).sub(yScaled);
        return fovDirections;
    }

    @Override
    public Vector3D[] getSrsAxes(Vector3D[] xyz) {
        xyz[0].set(1.0, 0.0, 0.0).rotateVectorByQuaternion(this.q);
        xyz[1].set(0.0, 1.0, 0.0).rotateVectorByQuaternion(this.q);
        xyz[2].set(0.0, 0.0, 1.0).rotateVectorByQuaternion(this.q);
        return xyz;
    }

    @Override
    public double[] getAlAcRates(double alInstrumentAngle, double acFieldAngle) {
        double cphi = FastMath.cos((double)alInstrumentAngle);
        double sphi = FastMath.sin((double)alInstrumentAngle);
        double tzeta = FastMath.tan((double)acFieldAngle);
        Vector3D spinRate = this.getSpinVectorInSrs().scl(86400.0);
        double phip = -spinRate.z + (spinRate.x * cphi + spinRate.y * sphi) * tzeta;
        double zetap = -spinRate.x * sphi + spinRate.y * cphi;
        return new double[]{phip, zetap};
    }

    @Override
    public double[] getAlAcRates(FOV fov, double alFieldAngle, double acFieldAngle) {
        return this.getAlAcRates(alFieldAngle + fov.getNumericalFieldIndex() * this.halfGamma, acFieldAngle);
    }
}

