/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gaia;

import gaiasky.util.gaia.AnalyticalAttitudeDataServer;
import gaiasky.util.gaia.ConcreteAttitude;
import gaiasky.util.gaia.IAttitude;
import gaiasky.util.math.QuaternionDouble;
import gaiasky.util.math.Vector3D;
import net.jafama.FastMath;

public class Epsl
extends AnalyticalAttitudeDataServer {
    static final Vector3D NECLP = new Vector3D(-Math.sin(OBLIQUITY_RAD), FastMath.cos((double)OBLIQUITY_RAD), 0.0);
    static final Vector3D[] xyz = new Vector3D[]{new Vector3D(), new Vector3D(), new Vector3D()};
    private final Mode currentMode;
    private Vector3D spinVector;
    private double omega;
    private int omegaRevs;

    public Epsl() {
        this.currentMode = Mode.PRECEDING;
        this.setDefault();
    }

    public Epsl(Mode mode) {
        this.currentMode = mode;
        this.setDefault();
    }

    @Override
    public synchronized IAttitude getAttitudeNative(long t) {
        this.nslSun.setTime(t);
        long tElapsed = t - this.getRefTime();
        long twicePeriod = 2L * this.getTargetScanPeriod();
        this.omegaRevs = 2 * (int)(tElapsed / twicePeriod);
        long tRemainder = tElapsed % twicePeriod;
        this.omega = this.getOmegaRef() + Math.PI * 4 * (double)tRemainder / (double)twicePeriod;
        QuaternionDouble q = new QuaternionDouble(Z_AXIS, 23.4392808);
        q.mul(new QuaternionDouble(Y_AXIS, FastMath.toDegrees((double)this.nslSun.getSolarLongitude())));
        q.mul(new QuaternionDouble(Z_AXIS, FastMath.toDegrees((double)(super.getNuRef() - 1.5707963267948966))));
        q.mul(new QuaternionDouble(X_AXIS, FastMath.toDegrees((double)(1.5707963267948966 - super.getXiRef()))));
        q.mul(new QuaternionDouble(Y_AXIS, FastMath.toDegrees((double)this.omega)));
        ConcreteAttitude att = new ConcreteAttitude(t, q, null, true);
        this.spinVector.set(NECLP).scl(this.nslSun.getSolarLongitudeDot());
        this.spinVector.scaleAdd(this.getTargetScanRate() * 24.0, att.getSrsAxes(xyz)[2]);
        QuaternionDouble qDot = new QuaternionDouble(0.5 * this.spinVector.z, 0.5 * this.spinVector.x, 0.5 * this.spinVector.y, 0.0);
        qDot.mul(q);
        att.setQuaternionDot(qDot);
        return att;
    }

    public Mode getMode() {
        return this.currentMode;
    }

    @Override
    public void setDefault() {
        super.setDefault();
        this.setTargetPrecessionRate(0.0);
        switch (this.currentMode.ordinal()) {
            case 0: {
                super.setNuRef(0.0);
                break;
            }
            case 1: {
                super.setNuRef(Math.PI);
            }
        }
        this.spinVector = new Vector3D();
        this.setInitialized(true);
    }

    public static enum Mode {
        PRECEDING,
        FOLLOWING;

    }
}

