/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gaia;

import gaiasky.util.gaia.AnalyticalAttitudeDataServer;
import gaiasky.util.gaia.Epsl;
import gaiasky.util.gaia.IAttitude;
import gaiasky.util.gaia.Nsl37;

public class EpslAndNsl
extends AnalyticalAttitudeDataServer {
    private final Epsl epsl = new Epsl();
    private final Nsl37 nsl = new Nsl37();

    public EpslAndNsl() {
        this.setDefault();
        this.copyRefValues();
    }

    public EpslAndNsl(long tRef, Epsl.Mode mode) {
        this.setDefault();
        if (mode == Epsl.Mode.FOLLOWING) {
            this.setNuRef(Math.PI);
        }
        this.copyRefValues();
        this.setRefTime(tRef);
    }

    private void copyRefValues() {
        this.epsl.setXiRef(this.getXiRef());
        this.epsl.setNuRef(this.getNuRef());
        this.epsl.setOmegaRef(this.getOmegaRef());
        this.epsl.setTargetScanPeriod(this.getTargetScanPeriod());
        this.epsl.setInitialized(true);
        this.nsl.setXiRef(this.getXiRef());
        this.nsl.setNuRef(this.getNuRef());
        this.nsl.setOmegaRef(this.getOmegaRef());
        this.nsl.setTargetPrecessionRate(this.getTargetPrecessionRate());
        this.nsl.setTargetScanPeriod(this.getTargetScanPeriod());
        this.nsl.setInitialized(false);
    }

    @Override
    public IAttitude getAttitudeNative(long tNow) {
        if (!this.initialized) {
            this.copyRefValues();
            super.setInitialized(true);
        }
        if (tNow < this.getRefTime()) {
            return this.epsl.getAttitude(tNow);
        }
        return this.nsl.getAttitude(tNow);
    }

    @Override
    public void setRefTime(long t) {
        super.setRefTime(t);
        this.nsl.setRefTime(t);
        this.epsl.setRefTime(t);
        this.setInitialized(false);
    }
}

