/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gaia;

public enum FOV {
    FOV1,
    FOV2,
    FOV3,
    FOV4;

    public static final FOV P;
    public static final FOV F;
    public static final FOV[] Telescopes;
    public static final FOV[] PrecedingFovs;
    public static final FOV[] FollowingFovs;
    public static final FOV[] MotionFovs;
    public static final FOV[] NullMotionFovs;

    public static FOV getFov(int fovIndex) {
        if (FOV.validFov(fovIndex)) {
            return FOV.values()[fovIndex];
        }
        return null;
    }

    public static FOV getFovByNumber(int fovNumber) {
        int fovIndex = fovNumber - 1;
        if (FOV.validFov(fovIndex)) {
            return FOV.values()[fovIndex];
        }
        return null;
    }

    public static int getFovCount() {
        return FOV.values().length;
    }

    public static boolean validFov(int fovIndex) {
        return fovIndex >= FOV1.getIndex() && fovIndex <= FOV4.getIndex();
    }

    public byte getIndex() {
        return (byte)this.ordinal();
    }

    public byte getNumber() {
        return (byte)(this.ordinal() + 1);
    }

    public double getNumericalFieldIndex() {
        if (this.equals((Object)FOV1) || this.equals((Object)FOV3)) {
            return 1.0;
        }
        return -1.0;
    }

    public byte getTelescopeIndex() {
        return (byte)(this.ordinal() % 2);
    }

    public byte getTelescopeNumber() {
        return (byte)(this.ordinal() % 2 + 1);
    }

    public boolean isFollowingTelescope() {
        return !this.isPrecedingTelescope();
    }

    public boolean isMotion() {
        return this.ordinal() < FOV3.ordinal();
    }

    public boolean isNullMotion() {
        return !this.isMotion();
    }

    public boolean isPrecedingTelescope() {
        return this.equals((Object)FOV1) || this.equals((Object)FOV3);
    }

    static {
        P = FOV1;
        F = FOV2;
        Telescopes = new FOV[]{P, F};
        PrecedingFovs = new FOV[]{FOV1, FOV3};
        FollowingFovs = new FOV[]{FOV2, FOV4};
        MotionFovs = new FOV[]{FOV1, FOV2};
        NullMotionFovs = new FOV[]{FOV3, FOV4};
    }
}

