/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gaia;

import gaiasky.data.api.OrientationServer;
import gaiasky.util.BinarySearchTree;
import gaiasky.util.Logger;
import gaiasky.util.Settings;
import gaiasky.util.gaia.AttitudeIntervalBean;
import gaiasky.util.gaia.AttitudeXmlParser;
import gaiasky.util.gaia.ConcreteAttitude;
import gaiasky.util.gaia.IAttitude;
import gaiasky.util.gaia.Nsl37;
import gaiasky.util.i18n.I18n;
import gaiasky.util.math.QuaternionDouble;
import java.time.Instant;
import java.util.Date;

public class GaiaAttitudeServer
implements OrientationServer {
    private static final Logger.Log logger = Logger.getLogger(GaiaAttitudeServer.class);
    IAttitude dummyAttitude;
    Nsl37 nsl;
    AttitudeIntervalBean prevAttitude = null;
    AttitudeIntervalBean current;
    Instant initialDate;
    private BinarySearchTree<AttitudeIntervalBean> attitudes;
    private IAttitude attitude;

    public GaiaAttitudeServer(String folder) {
        if (Settings.settings.data.realGaiaAttitude) {
            this.attitudes = AttitudeXmlParser.parseFolder(folder);
            if (this.attitudes != null) {
                this.initialDate = ((AttitudeIntervalBean)this.attitudes.findMin()).activationTime;
                this.current = new AttitudeIntervalBean("current", null, null, "dummy");
                this.dummyAttitude = new ConcreteAttitude(0L, new QuaternionDouble(), false);
            } else {
                logger.error("Error loading real attitude: " + folder);
            }
        } else {
            this.nsl = new Nsl37();
        }
    }

    @Override
    public QuaternionDouble updateOrientation(Date date) {
        return this.updateOrientation(date.toInstant());
    }

    @Override
    public QuaternionDouble updateOrientation(Instant instant) {
        if (this.attitude != null && this.attitude.getTime() == instant.toEpochMilli()) {
            return this.attitude.getQuaternion();
        }
        this.attitude = this.getAttitude(instant);
        if (this.attitude != null) {
            return this.attitude.getQuaternion();
        }
        return null;
    }

    @Override
    public QuaternionDouble getCurrentOrientation() {
        return this.hasOrientation() ? this.attitude.getQuaternion() : null;
    }

    @Override
    public boolean hasOrientation() {
        return this.attitude != null;
    }

    public synchronized IAttitude getAttitude(Instant date) {
        Object result;
        if (Settings.settings.data.realGaiaAttitude) {
            if (date.compareTo(this.initialDate) < 0) {
                result = this.dummyAttitude;
            } else {
                try {
                    this.current.activationTime = date;
                    AttitudeIntervalBean att = (AttitudeIntervalBean)this.attitudes.findIntervalStart(this.current);
                    if (this.prevAttitude != null && !att.equals(this.prevAttitude)) {
                        logger.info(I18n.msg("notif.attitude.changed", att.toString(), att.activationTime));
                    }
                    this.prevAttitude = att;
                    result = att.get(date);
                }
                catch (Exception e) {
                    logger.error(e);
                    if (this.nsl == null) {
                        this.nsl = new Nsl37();
                    }
                    result = this.nsl.getAttitude(date);
                }
            }
        } else {
            result = this.nsl.getAttitude(date);
        }
        return result;
    }

    public synchronized String getCurrentAttitudeName() {
        if (this.prevAttitude != null) {
            return this.prevAttitude.file;
        }
        return null;
    }
}

