/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gaia;

import gaiasky.util.Logger;
import gaiasky.util.gaia.ConcreteAttitude;
import gaiasky.util.gaia.IAttitude;
import gaiasky.util.gaia.NumericalAttitudeDataServer;
import gaiasky.util.gaia.time.Duration;
import gaiasky.util.gaia.time.GtiList;
import gaiasky.util.gaia.utils.AttitudeUtils;
import gaiasky.util.gaia.utils.Interpolator;
import gaiasky.util.math.QuaternionDouble;
import net.jafama.FastMath;

public abstract class HermiteInterpolatedAttitudeDataServer
extends NumericalAttitudeDataServer<IAttitude> {
    protected int nT;
    protected long[] tNs;
    protected double[] qX;
    protected double[] qY;
    protected double[] qZ;
    protected double[] qW;
    protected double[] rateX;
    protected double[] rateY;
    protected double[] rateZ;

    protected HermiteInterpolatedAttitudeDataServer(long tStart, Duration tLength) {
        long tEnd = tStart + tLength.asNanoSecs();
        this.gtis = new GtiList();
        try {
            this.gtis.add(tStart, tEnd);
        }
        catch (RuntimeException e) {
            Logger.getLogger(this.getClass()).error(e);
        }
    }

    @Override
    public abstract void initialize() throws RuntimeException;

    @Override
    public IAttitude getAttitudeNative(long t) throws RuntimeException {
        int left = AttitudeUtils.findLeftIndexVar(t, this.tNs, 0);
        if (left < 0 || left > this.nT - 2) {
            String msg = "t < tBeg or >= tEnd, t = + " + t + ", tBeg = " + this.getStartTime() + ", tEnd = " + this.getStopTime();
            throw new RuntimeException(msg);
        }
        double qXDotL = 0.5 * (this.qY[left] * this.rateZ[left] - this.qZ[left] * this.rateY[left] + this.qW[left] * this.rateX[left]);
        double qYDotL = 0.5 * (-this.qX[left] * this.rateZ[left] + this.qZ[left] * this.rateX[left] + this.qW[left] * this.rateY[left]);
        double qZDotL = 0.5 * (this.qX[left] * this.rateY[left] - this.qY[left] * this.rateX[left] + this.qW[left] * this.rateZ[left]);
        double qWDotL = 0.5 * (-this.qX[left] * this.rateX[left] - this.qY[left] * this.rateY[left] - this.qZ[left] * this.rateZ[left]);
        double qXDotL1 = 0.5 * (this.qY[left + 1] * this.rateZ[left + 1] - this.qZ[left + 1] * this.rateY[left + 1] + this.qW[left + 1] * this.rateX[left + 1]);
        double qYDotL1 = 0.5 * (-this.qX[left + 1] * this.rateZ[left + 1] + this.qZ[left + 1] * this.rateX[left + 1] + this.qW[left + 1] * this.rateY[left + 1]);
        double qZDotL1 = 0.5 * (this.qX[left + 1] * this.rateY[left + 1] - this.qY[left + 1] * this.rateX[left + 1] + this.qW[left + 1] * this.rateZ[left + 1]);
        double qWDotL1 = 0.5 * (-this.qX[left + 1] * this.rateX[left + 1] - this.qY[left + 1] * this.rateY[left + 1] - this.qZ[left + 1] * this.rateZ[left + 1]);
        double timeUnit = 8.64E13;
        double x0 = 0.0;
        double x1 = (double)(this.tNs[left + 1] - this.tNs[left]) / timeUnit;
        double x = (double)(t - this.tNs[left]) / timeUnit;
        double[] intX = Interpolator.linear(x, x0, this.qX[left], x1, this.qX[left + 1]);
        double[] intY = Interpolator.linear(x, x0, this.qY[left], x1, this.qY[left + 1]);
        double[] intZ = Interpolator.linear(x, x0, this.qZ[left], x1, this.qZ[left + 1]);
        double[] intW = Interpolator.linear(x, x0, this.qW[left], x1, this.qW[left + 1]);
        QuaternionDouble qInt = new QuaternionDouble(intX[0], intY[0], intZ[0], intW[0]);
        double fact = 1.0 / FastMath.sqrt((double)qInt.len2());
        return new ConcreteAttitude(t, qInt.nor(), new QuaternionDouble(intX[1] * fact, intY[1] * fact, intZ[1] * fact, intW[1] * fact), false);
    }
}

