/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gaia;

import gaiasky.util.coord.Coordinates;
import gaiasky.util.coord.NslSun;
import gaiasky.util.gaia.Nsl37;
import gaiasky.util.gaia.NslUtil;
import gaiasky.util.gaia.time.Secs;
import gaiasky.util.gaia.utils.CircleArea;
import gaiasky.util.gaia.utils.ComplexArea;
import gaiasky.util.gaia.utils.DiffnFunctionNs;
import gaiasky.util.gaia.utils.Place;
import gaiasky.util.gaia.utils.RungeKuttaNs;
import gaiasky.util.math.Matrix4D;
import gaiasky.util.math.QuaternionDouble;
import gaiasky.util.math.Vector3D;
import java.util.Arrays;
import net.jafama.FastMath;

public class ModifiedScanningLaw {
    protected static final double PI = Math.PI;
    protected static final double TWO_PI = Math.PI * 2;
    protected static final double FOUR_PI = Math.PI * 4;
    protected static final double DEG = Math.PI / 180;
    protected static final double DAY_NS = 8.64E13;
    protected static final double obliquity = 0.4090926248412669;
    protected static Vector3D eclPole = new Vector3D(0.0, 0.0, 1.0).rotate(23.43928083333333, 0.0, 0.0, 1.0);
    private final NslSun sun = new NslSun();
    private final Nsl37 nsl = new Nsl37();
    protected long refEpoch;
    protected double precRate;
    protected long scanPerNs;
    protected double scanRate;
    protected double sNom;
    protected double lSunRef;
    protected double omegaRef;
    protected double nuRef;
    protected long tNow;
    protected double lSun;
    protected double lSunDot;
    protected double xi;
    protected double sinXi;
    protected double cosXi;
    protected double nu;
    protected double omega;
    protected int omegaRevs;
    protected boolean initialized;
    protected long tBeg;
    protected long tBegNs;
    protected double nuBeg;
    protected double deltaOmegaBeg;
    protected int omegaRevsBeg;
    protected double deltaOmega;
    protected double deltaOmegaDot;
    protected double omegaDot;
    protected double nuDot;
    protected long tOld;
    protected double[] y = new double[2];
    protected double[] yOld = new double[2];
    protected double[] dydt = new double[2];
    protected Derivm dn;
    protected double sFactor;
    protected double zMax;
    protected double zMin;
    protected double s1min;
    protected double sRed;
    protected double kappa;
    protected boolean reduced;
    protected Vector3D spinAxis = new Vector3D();
    protected Vector3D[] refDir;
    protected long unit;
    protected long dt;
    protected ComplexArea[] highDensityAreas;
    protected ScanState status;

    public ModifiedScanningLaw(long gtBeg) {
        this.tBegNs = this.tBeg = gtBeg;
        this.refEpoch = this.tBeg;
        this.nsl.setRefTime(this.refEpoch);
        this.xi = this.nsl.getXiRef();
        this.nuRef = this.nsl.getNuRef();
        this.omegaRef = this.nsl.getOmegaRef();
        this.scanRate = this.nsl.getTargetScanRate();
        this.precRate = this.nsl.getTargetPrecessionRate();
        this.sFactor = 0.15;
        this.zMax = FastMath.toRadians((double)0.5);
        this.zMin = FastMath.toRadians((double)0.3);
        this.s1min = 0.5;
        this.highDensityAreas = new ComplexArea[0];
        this.refDir = new Vector3D[0];
        this.dn = new Derivm();
        this.unit = 86400000000000L;
        double stepSecs = 150.0;
        this.setMaxInternalTimeStep(Math.round(stepSecs * 1.0E9));
        this.initialize();
    }

    protected void initialize() {
        this.scanPerNs = new Secs(1296000.0 / this.scanRate).asNanoSecs();
        this.sNom = NslUtil.calcSNom(this.xi, this.precRate);
        this.sRed = this.sFactor * this.sNom;
        this.sinXi = FastMath.sin((double)this.xi);
        this.cosXi = FastMath.cos((double)this.xi);
        this.sun.setTime(this.refEpoch);
        this.lSunRef = this.sun.getSolarLongitude();
        this.tNow = this.refEpoch;
        this.sun.setTime(this.tNow);
        this.lSun = this.sun.getSolarLongitude();
        this.lSunDot = this.sun.getSolarLongitudeDot();
        this.nuBeg = this.nuRef;
        this.deltaOmegaBeg = this.omegaRef;
        this.omegaRevsBeg = 0;
        this.reset();
        if (this.refEpoch < this.tBeg) {
            this.stepForward(this.tBegNs - this.refEpoch);
            this.nuBeg = this.nu;
            this.deltaOmegaBeg = this.deltaOmega;
            this.omegaRevsBeg = this.omegaRevs;
            this.tNow = this.tBegNs;
            this.reset();
        }
    }

    protected void reset() {
        this.nu = this.nuBeg;
        this.deltaOmega = this.deltaOmegaBeg;
        this.omegaRevs = this.omegaRevsBeg;
        this.y[0] = this.nu;
        this.y[1] = this.deltaOmega;
        this.dydt = this.dn.derivn(this.tNow, this.y);
        this.nuDot = this.dydt[0];
        this.deltaOmegaDot = this.dydt[1];
        this.tOld = this.tNow;
        this.yOld[0] = this.y[0];
        this.yOld[1] = this.y[1];
        this.calcOmega();
        this.initialized = true;
    }

    public void setRefNuOmega(double refNu, double refOmega) {
        this.nuRef = refNu;
        this.omegaRef = refOmega;
        this.initialized = false;
    }

    public void setRefXi(double refXi) {
        this.xi = refXi;
        this.initialized = false;
    }

    public long getMaxInternalTimeStep() {
        return this.dt;
    }

    public void setMaxInternalTimeStep(long stepNs) {
        this.dt = stepNs;
    }

    public void setMslParameters(double factor, double zMaxDeg, double zMinDeg, double s1Min) {
        this.sFactor = factor;
        this.s1min = s1Min;
        this.zMax = FastMath.toRadians((double)zMaxDeg);
        this.zMin = FastMath.toRadians((double)zMinDeg);
        this.initialized = false;
    }

    public void setTypicalHighDensityArea() {
        ComplexArea ca = new ComplexArea();
        ca.setName("BW + Sgr I");
        Vector3D dir1 = new Vector3D();
        double radius1 = Math.PI / 360;
        Coordinates.sphericalToCartesian(0.01815142422074103, -0.06771877497737998, radius1, dir1);
        Vector3D dir2 = new Vector3D();
        double radius2 = Math.PI / 360;
        Coordinates.sphericalToCartesian(0.025132741228718343, -0.0460766922526503, radius2, dir2);
        Matrix4D galEq = Coordinates.eqToGal();
        dir1.mul(galEq);
        dir2.mul(galEq);
        ca.add(new CircleArea(new Place(dir1), radius1));
        ca.add(new CircleArea(new Place(dir2), radius2));
        this.setHighDensityAreas(new ComplexArea[]{ca});
    }

    public ComplexArea[] getHighDensityAreas() {
        return this.highDensityAreas;
    }

    public void setHighDensityAreas(ComplexArea[] areas) {
        if (areas != null) {
            int nAreas = areas.length;
            this.highDensityAreas = new ComplexArea[nAreas];
            this.refDir = new Vector3D[nAreas];
            for (int i = 0; i < nAreas; ++i) {
                this.highDensityAreas[i] = areas[i];
                this.refDir[i] = areas[i].getMidPoint().getDirection();
            }
        }
        this.initialized = false;
    }

    public void stepForward(long tStepNs) {
        if (!this.initialized) {
            this.initialize();
        }
        this.tOld = this.tNow;
        this.yOld[0] = this.y[0];
        this.yOld[1] = this.y[1];
        long tNew = this.tOld + tStepNs;
        this.y = RungeKuttaNs.fourthOrder(this.dn, this.tOld, this.yOld, tNew, this.dt, this.unit);
        this.dydt = this.dn.derivn(tNew, this.y);
        this.sun.setTime(tNew);
        this.tNow = tNew;
        this.lSun = this.sun.getSolarLongitude();
        this.lSunDot = this.sun.getSolarLongitudeDot();
        this.nu = this.y[0];
        this.deltaOmega = this.y[1];
        this.nuDot = this.dydt[0];
        this.deltaOmegaDot = this.dydt[1];
        this.calcOmega();
    }

    public void regretLastStep() {
        this.tNow = this.tOld;
        this.y = Arrays.copyOf(this.yOld, this.yOld.length);
        this.dydt = this.dn.derivn(this.tNow, this.y);
        this.sun.setTime(this.tNow);
        this.lSun = this.sun.getSolarLongitude();
        this.lSunDot = this.sun.getSolarLongitudeDot();
        this.nu = this.y[0];
        this.deltaOmega = this.y[1];
        this.nuDot = this.dydt[0];
        this.deltaOmegaDot = this.dydt[1];
        this.calcOmega();
    }

    public double getLSun() {
        return this.lSun;
    }

    public double getLSunDot() {
        return this.lSunDot;
    }

    public double getXi() {
        return this.xi;
    }

    public double getNu() {
        return this.nu;
    }

    public double getNuMod4Pi() {
        double rev = FastMath.floor((double)(this.nu / (Math.PI * 4)));
        return this.nu - Math.PI * 4 * rev;
    }

    public double getOmega() {
        return this.omega;
    }

    public double getOmegaMod4Pi() {
        return this.omega + Math.PI * 2 * (double)(this.omegaRevs % 2);
    }

    public int getOmegaRevs() {
        return this.omegaRevs;
    }

    public double getNuDot() {
        return this.nuDot;
    }

    public double getOmegaDot() {
        return this.omegaDot;
    }

    public double getDeltaOmega() {
        return this.deltaOmega;
    }

    public double getDeltaOmegaDot() {
        return this.deltaOmegaDot;
    }

    public double getCurrentS() {
        double cosNu = FastMath.cos((double)this.nu);
        double sinNu = FastMath.sin((double)this.nu);
        return FastMath.sqrt((double)(Math.pow(cosNu, 2.0) + FastMath.pow((double)(this.getKappa() * this.sinXi - this.cosXi * sinNu), (double)2.0)));
    }

    public double getKappa() {
        return this.kappa;
    }

    public ScanState getStatus() {
        return this.status;
    }

    public long getGTimeBeg() {
        return this.tBeg;
    }

    public long getRefEpoch() {
        return this.refEpoch;
    }

    public void setRefEpoch(long refEpoch) throws RuntimeException {
        if (refEpoch > this.tBeg) {
            throw new RuntimeException("Reference epoch for MSL cannot be later than the starting time");
        }
        this.refEpoch = refEpoch;
        this.initialized = false;
    }

    public double getRefNu() {
        return this.nuRef;
    }

    public void setRefNu(double refNu) {
        this.nuRef = refNu;
        this.initialized = false;
    }

    public double getRefOmega() {
        return this.omegaRef;
    }

    public void setRefOmega(double refOmega) {
        this.omegaRef = refOmega;
        this.initialized = false;
    }

    public double getPrecRate() {
        return this.precRate;
    }

    public void setPrecRate(double precRate) {
        this.precRate = precRate;
        this.initialized = false;
    }

    public double getScanRate() {
        return this.scanRate;
    }

    public void setScanRate(double scanRate) {
        this.scanRate = scanRate;
        this.scanPerNs = new Secs(1296000.0 / scanRate).asNanoSecs();
        this.initialized = false;
    }

    protected void calcOmega() {
        long nsSinceRef = this.tNow - this.refEpoch;
        this.omegaRevs = (int)(nsSinceRef / this.scanPerNs);
        long remainder = nsSinceRef - (long)this.omegaRevs * this.scanPerNs;
        double fractionalPeriod = (double)remainder / (double)this.scanPerNs;
        this.omega = this.deltaOmega + Math.PI * 2 * fractionalPeriod;
        this.adjustOmega();
        this.omegaDot = this.scanRate * (Math.PI * 2) / 15.0 + this.deltaOmegaDot;
    }

    public ModifiedScanningLaw advanceScanningTo(long newTimeNs) {
        if (newTimeNs >= this.tNow) {
            this.stepForward(newTimeNs - this.tNow);
        } else {
            this.initialized = false;
            this.stepForward(newTimeNs - this.tBegNs);
        }
        return this;
    }

    protected void adjustOmega() {
        if (this.omega >= Math.PI * 2) {
            int n = (int)(this.omega / (Math.PI * 2));
            this.omega -= (double)n * (Math.PI * 2);
            this.omegaRevs += n;
        } else if (this.omega < 0.0) {
            int n = 1 + (int)(-this.omega / (Math.PI * 2));
            this.omega += (double)n * (Math.PI * 2);
            this.omegaRevs -= n;
        }
    }

    protected double transitionKappa(double x, double kappaN, double kappaR, TransitionFunction tf) {
        double kappa = 0.0;
        switch (tf.ordinal()) {
            case 0: {
                kappa = kappaR * (1.0 - x) + kappaN * x;
                break;
            }
            case 2: {
                kappa = 0.5 * (kappaN + kappaR - (kappaN - kappaR) * FastMath.cos((double)(Math.PI * x)));
                break;
            }
            case 1: {
                kappa = FastMath.sqrt((double)((1.0 - x) * kappaR * kappaR + x * kappaN * kappaN));
                break;
            }
            case 3: {
                double p = x < 0.5 ? x * x * (3.0 - 2.0 * x) : 1.0 - (1.0 - x) * (1.0 - x) * (1.0 + 2.0 * x);
                kappa = FastMath.sqrt((double)((1.0 - p) * kappaR * kappaR + p * kappaN * kappaN));
            }
        }
        return kappa;
    }

    protected double sigmoid(double x) {
        double e = FastMath.exp((double)x);
        return (1.0 + (e - 1.0 / e) / (e + 1.0 / e)) / 2.0;
    }

    public class Derivm
    implements DiffnFunctionNs {
        @Override
        public double[] derivn(long t, double[] y) {
            double[] dydt = new double[y.length];
            ModifiedScanningLaw.this.sun.setTime(t);
            Vector3D sunDir = new Vector3D();
            ModifiedScanningLaw.this.sun.getSolarDirection(sunDir);
            double sLonDot = ModifiedScanningLaw.this.sun.getSolarLongitudeDot();
            double cosNu = FastMath.cos((double)y[0]);
            double sinNu = FastMath.sin((double)y[0]);
            double kappaN = (Math.sqrt(ModifiedScanningLaw.this.sNom * ModifiedScanningLaw.this.sNom - cosNu * cosNu) + ModifiedScanningLaw.this.cosXi * sinNu) / ModifiedScanningLaw.this.sinXi;
            QuaternionDouble q = ModifiedScanningLaw.this.sun.heliotropicToQuaternion(t, ModifiedScanningLaw.this.xi, y[0], y[1]);
            ModifiedScanningLaw.this.spinAxis.set(0.0, 0.0, 1.0).rotateVectorByQuaternion(q);
            Place spinAxisPlace = new Place(ModifiedScanningLaw.this.spinAxis);
            double altMin = 10.0;
            int indexAltMin = 0;
            for (int i = 0; i < ModifiedScanningLaw.this.highDensityAreas.length; ++i) {
                double alt = ModifiedScanningLaw.this.highDensityAreas[i].altitude(spinAxisPlace);
                if (!(alt < altMin)) continue;
                altMin = alt;
                indexAltMin = i;
            }
            if (altMin < ModifiedScanningLaw.this.zMax) {
                ModifiedScanningLaw.this.reduced = true;
                double kappaR = kappaN;
                double s0 = Vector3D.crs(eclPole, ModifiedScanningLaw.this.spinAxis).dot(ModifiedScanningLaw.this.refDir[indexAltMin]);
                double s1 = Vector3D.crs(sunDir, ModifiedScanningLaw.this.spinAxis).dot(ModifiedScanningLaw.this.refDir[indexAltMin]);
                if (s1 > 0.0) {
                    kappaR = FastMath.min((double)kappaN, (double)((ModifiedScanningLaw.this.sRed - s0) / s1));
                } else if (s1 < 0.0) {
                    kappaR = FastMath.min((double)kappaN, (double)((ModifiedScanningLaw.this.sRed + s0) / -s1));
                }
                if (kappaR < 0.0) {
                    kappaR = 0.0;
                }
                kappaR = kappaN - (kappaN - kappaR) * ModifiedScanningLaw.this.sigmoid((Math.abs(s1) - ModifiedScanningLaw.this.s1min) / 0.1);
                if (altMin < ModifiedScanningLaw.this.zMin) {
                    ModifiedScanningLaw.this.kappa = kappaR;
                    ModifiedScanningLaw.this.status = ScanState.MODIFIED;
                } else {
                    double x = (altMin - ModifiedScanningLaw.this.zMin) / (ModifiedScanningLaw.this.zMax - ModifiedScanningLaw.this.zMin);
                    ModifiedScanningLaw.this.kappa = ModifiedScanningLaw.this.transitionKappa(x, kappaN, kappaR, TransitionFunction.FANCY);
                    ModifiedScanningLaw.this.status = ScanState.TRANSITION;
                }
            } else {
                ModifiedScanningLaw.this.reduced = false;
                ModifiedScanningLaw.this.kappa = kappaN;
                ModifiedScanningLaw.this.status = ScanState.NOMINAL;
            }
            dydt[0] = ModifiedScanningLaw.this.kappa * sLonDot;
            dydt[1] = -ModifiedScanningLaw.this.cosXi * dydt[0] - ModifiedScanningLaw.this.sinXi * sinNu * sLonDot;
            return dydt;
        }
    }

    public static enum ScanState {
        NOMINAL,
        TRANSITION,
        MODIFIED;

    }

    protected static enum TransitionFunction {
        LINEAR,
        SQUAREROOT,
        COSINE,
        FANCY;

    }
}

