/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gaia;

import gaiasky.util.gaia.AttitudeConverter;
import gaiasky.util.gaia.ConcreteAttitude;
import gaiasky.util.gaia.HermiteInterpolatedAttitudeDataServer;
import gaiasky.util.gaia.IAttitude;
import gaiasky.util.gaia.ModifiedScanningLaw;
import gaiasky.util.gaia.time.Duration;
import gaiasky.util.gaia.utils.AttitudeUtils;
import gaiasky.util.math.QuaternionDouble;
import java.util.ArrayList;
import java.util.List;
import net.jafama.FastMath;

public class MslAttitudeDataServer
extends HermiteInterpolatedAttitudeDataServer {
    protected ModifiedScanningLaw msl;
    protected double maxStepSec;
    protected long step;
    protected long timeGranularity = 1000000000000L;
    protected boolean useDefaultStepForIntegrator = true;
    protected long stepForIntegrator;
    protected double extraOmega = 0.0;
    protected boolean[] reducedPrecession;
    protected boolean[] transitionPrecession;
    protected volatile long[] precessionRateChanges;
    protected QuaternionDouble qExtraOmega = new QuaternionDouble(0.0, 0.0, 0.0, 1.0);

    public MslAttitudeDataServer(long tStart, Duration tLength, ModifiedScanningLaw msl) {
        super(tStart, tLength);
        if (tStart < msl.getGTimeBeg()) {
            throw new IllegalArgumentException("MslAttitudeDataServer starts earlier than ModifiedScanningLaw");
        }
        super.setRefTime(msl.getRefEpoch());
        this.msl = msl;
        this.maxStepSec = 125.0;
        this.initialized = false;
    }

    @Override
    public void initialize() {
        long tBeg = super.getStartTime();
        long tEnd = super.getStopTime();
        long refEpoch = this.getRefTime();
        long tBegNsFromRef = tBeg - refEpoch;
        tBegNsFromRef = this.timeGranularity * (tBegNsFromRef / this.timeGranularity);
        long tBegNs = refEpoch + tBegNsFromRef;
        long tEndNsFromRef = tEnd - refEpoch;
        tEndNsFromRef = this.timeGranularity * ((tEndNsFromRef - 1L) / this.timeGranularity + 1L);
        long tEndNs = refEpoch + tEndNsFromRef;
        long maxStep = FastMath.round((double)(this.maxStepSec * 1.0E9));
        long part = 1L;
        this.step = this.timeGranularity;
        while (this.step > maxStep || this.timeGranularity - part * this.step > 0L) {
            this.step = this.timeGranularity / ++part;
        }
        this.nT = 1 + (int)((tEndNsFromRef - tBegNsFromRef) / this.step);
        if (this.nT < 2) {
            this.nT = 2;
            this.step = tEndNsFromRef - tBegNsFromRef;
        }
        if (this.useDefaultStepForIntegrator) {
            this.stepForIntegrator = this.step;
        }
        this.msl.setMaxInternalTimeStep(this.stepForIntegrator);
        this.tNs = new long[this.nT];
        this.qX = new double[this.nT];
        this.qY = new double[this.nT];
        this.qZ = new double[this.nT];
        this.qW = new double[this.nT];
        this.rateX = new double[this.nT];
        this.rateY = new double[this.nT];
        this.rateZ = new double[this.nT];
        this.reducedPrecession = new boolean[this.nT];
        this.transitionPrecession = new boolean[this.nT];
        double[] om = new double[this.nT];
        this.tNs[0] = tBegNs;
        for (int i = 1; i < this.nT - 1; ++i) {
            this.tNs[i] = this.tNs[0] + (long)i * this.step;
        }
        this.tNs[this.nT - 1] = tEndNs;
        long tNowNs = this.msl.getGTimeBeg();
        for (int i = 0; i < this.nT; ++i) {
            this.msl.stepForward(this.tNs[i] - tNowNs);
            double lSun = this.msl.getLSun();
            double xi = this.msl.getXi();
            double nu = this.msl.getNuMod4Pi();
            om[i] = this.msl.getOmegaMod4Pi();
            double omega = om[i];
            double lSunDot = this.msl.getLSunDot();
            double nuDot = this.msl.getNuDot();
            double omegaDot = this.msl.getOmegaDot();
            QuaternionDouble[] qq = AttitudeConverter.heliotropicToQuaternions(lSun, xi, nu, omega, lSunDot, nuDot, omegaDot);
            QuaternionDouble q = qq[0];
            QuaternionDouble qInvQDot = qq[1].mulLeftInverse(q);
            this.qX[i] = q.x;
            this.qY[i] = q.y;
            this.qZ[i] = q.z;
            this.qW[i] = q.w;
            this.rateX[i] = 2.0 * qInvQDot.x;
            this.rateY[i] = 2.0 * qInvQDot.y;
            this.rateZ[i] = 2.0 * qInvQDot.z;
            this.reducedPrecession[i] = this.msl.getStatus() != ModifiedScanningLaw.ScanState.NOMINAL;
            this.transitionPrecession[i] = this.msl.getStatus() == ModifiedScanningLaw.ScanState.TRANSITION;
            tNowNs = this.tNs[i];
        }
        this.initialized = true;
    }

    public boolean inGap(long time) {
        return false;
    }

    public void setMaxStepForIntegrator(double maxStepInSec) {
        this.stepForIntegrator = FastMath.round((double)(maxStepInSec * 1.0E9));
        this.useDefaultStepForIntegrator = false;
        this.initialized = false;
    }

    public double getMaxStep() {
        return this.maxStepSec;
    }

    public void setMaxStep(double maxStepInSec) {
        this.maxStepSec = maxStepInSec;
        this.initialized = false;
    }

    public long[] getNodeParams() {
        return new long[]{this.tNs[0], this.step, this.nT};
    }

    private double getExtraOmega() {
        return this.extraOmega;
    }

    private void setExtraOmega(double extraOmega) {
        this.extraOmega = extraOmega;
        this.qExtraOmega.set(0.0, 0.0, FastMath.sin((double)(extraOmega / 2.0)), FastMath.cos((double)(extraOmega / 2.0)));
    }

    public double getRefOmega() {
        return this.msl.getRefOmega() + this.getExtraOmega();
    }

    public void setRefOmega(double refOmega) {
        this.setExtraOmega(refOmega - this.msl.getRefOmega());
    }

    public ModifiedScanningLaw getMsl() {
        return this.msl;
    }

    @Override
    public IAttitude getAttitudeNative(long t) throws RuntimeException {
        if (!this.initialized) {
            this.initialize();
        }
        IAttitude att = super.getAttitudeNative(t);
        if (this.extraOmega != 0.0) {
            QuaternionDouble q = att.getQuaternion();
            QuaternionDouble qDot = att.getQuaternionDot();
            q.mul(this.qExtraOmega);
            qDot.mul(this.qExtraOmega);
            att = new ConcreteAttitude(t, q, qDot, true);
        }
        return att;
    }

    public boolean isModified(long t) {
        int left = AttitudeUtils.findLeftIndexVar(t, this.tNs, 0);
        return this.reducedPrecession[left] || this.reducedPrecession[left + 1];
    }

    public boolean isTransition(long t) {
        int left = AttitudeUtils.findLeftIndexVar(t, this.tNs, 0);
        return this.transitionPrecession[left] || this.transitionPrecession[left + 1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] getPrecessionRateChanges() {
        if (!this.initialized) {
            this.initialize();
        }
        if (this.precessionRateChanges == null) {
            MslAttitudeDataServer mslAttitudeDataServer = this;
            synchronized (mslAttitudeDataServer) {
                if (this.precessionRateChanges == null) {
                    this.precessionRateChanges = this.calculatePrecessionRateChanges();
                }
            }
        }
        return this.precessionRateChanges;
    }

    private long[] calculatePrecessionRateChanges() {
        ArrayList<Long> changes = new ArrayList<Long>();
        for (int i = 1; i < this.reducedPrecession.length; ++i) {
            if (this.reducedPrecession[i - 1] == this.reducedPrecession[i]) continue;
            long t_prev = this.tNs[i - 1];
            long t_i = this.tNs[i];
            changes.add((t_prev + t_i) / 2L);
        }
        return this.toPrimitive(changes);
    }

    private long[] toPrimitive(List<Long> l) {
        long[] res = new long[l.size()];
        int i = 0;
        for (Long d : l) {
            res[i++] = d;
        }
        return res;
    }
}

