/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gaia;

import gaiasky.util.coord.AstroUtils;
import gaiasky.util.coord.NslSun;
import gaiasky.util.gaia.AnalyticalAttitudeDataServer;
import gaiasky.util.gaia.AttitudeConverter;
import gaiasky.util.gaia.ConcreteAttitude;
import gaiasky.util.gaia.IAttitude;
import gaiasky.util.gaia.NslUtil;
import gaiasky.util.math.QuaternionDouble;
import net.jafama.FastMath;

public class Nsl37
extends AnalyticalAttitudeDataServer {
    private double sx;
    private double cx;
    private double sx2;
    private double cx2;
    private double cx3;
    private double sx4;
    private double cx4;
    private double cx6;
    private double c1a;
    private double c2a;
    private double c3a;
    private double c4a;
    private double c5a;
    private double s1a;
    private double s2a;
    private double s3a;
    private double s4a;
    private double on;
    private double ocn;
    private double os2n;
    private double oc3n;
    private double os4n;
    private double oc5n;
    private double c0v;
    private double c1v;
    private double c2v;
    private double c3v;
    private double c4v;
    private double s1v;
    private double s2v;
    private double s3v;
    private double s4v;
    private double lSunRef;
    private double xi;
    private double nu0;
    private long scanPerNs;
    private double nu;
    private double omega;
    private double nuDot;
    private double omegaDot;
    private int nuRevs;
    private int omegaRevs;

    public IAttitude getAttitudeNative(double julianDate) {
        long tNs = (long)((julianDate - AstroUtils.JD_J2010) * 8.64E13);
        return this.getAttitudeNative(tNs);
    }

    @Override
    protected IAttitude getAttitudeNative(long tNow) {
        int n;
        if (!this.initialized) {
            this.recomputeConstants();
            this.setInitialized(true);
        }
        this.nslSun.setTime(tNow);
        double lSun = this.nslSun.getSolarLongitude();
        double lSunDot = this.nslSun.getSolarLongitudeDot();
        double precRate = this.getTargetPrecessionRate();
        double z = precRate * (lSun - this.lSunRef);
        double zDot = precRate * lSunDot;
        double s1z = FastMath.sin((double)z);
        double c1z = FastMath.cos((double)z);
        double s2z = 2.0 * c1z * s1z;
        double c2z = 2.0 * c1z * c1z - 1.0;
        double s3z = s2z * c1z + c2z * s1z;
        double c3z = c2z * c1z - s2z * s1z;
        double s4z = 2.0 * c2z * s2z;
        double c4z = 2.0 * c2z * c2z - 1.0;
        this.nu = this.getNuRef() + z + this.c0v + this.c1v * c1z + this.s1v * s1z + this.c2v * c2z + this.s2v * s2z + this.c3v * c3z + this.s3v * s3z + this.c4v * c4z + this.s4v * s4z;
        this.nuDot = zDot * (1.0 - this.c1v * s1z + this.s1v * c1z - 2.0 * this.c2v * s2z + 2.0 * this.s2v * c2z - 3.0 * this.c3v * s3z + 3.0 * this.s3v * c3z - 4.0 * this.c4v * s4z + 4.0 * this.s4v * c4z);
        long tElapsed = tNow - this.getRefTime();
        this.omegaRevs = (int)(tElapsed / this.scanPerNs);
        double omegaArg = Math.PI * 2 * (double)(tElapsed - (long)this.omegaRevs * this.scanPerNs) / (double)this.scanPerNs;
        this.omega = this.getOmegaRef() + omegaArg + this.on * (this.nu - this.nu0) + this.ocn * (Math.cos(this.nu) - this.c1a) + this.os2n * (Math.sin(2.0 * this.nu) - this.s2a) + this.oc3n * (Math.cos(3.0 * this.nu) - this.c3a) + this.os4n * (Math.sin(4.0 * this.nu) - this.s4a) + this.oc5n * (Math.cos(5.0 * this.nu) - this.c5a);
        this.omegaDot = 5.4286721054031625E14 / (double)this.scanPerNs + this.nuDot * (this.on - this.ocn * FastMath.sin((double)this.nu) + 2.0 * this.os2n * FastMath.cos((double)(2.0 * this.nu)) - 3.0 * this.oc3n * FastMath.sin((double)(3.0 * this.nu)) + 4.0 * this.os4n * FastMath.cos((double)(4.0 * this.nu)) - 5.0 * this.oc5n * FastMath.sin((double)(5.0 * this.nu)));
        this.nuRevs = 0;
        if (this.nu >= Math.PI * 2) {
            n = (int)(this.nu / (Math.PI * 2));
            this.nu -= (double)n * (Math.PI * 2);
            this.nuRevs += n;
        } else if (this.nu < 0.0) {
            n = 1 + (int)(-this.nu / (Math.PI * 2));
            this.nu += (double)n * (Math.PI * 2);
            this.nuRevs -= n;
        }
        if (this.omega >= Math.PI * 2) {
            n = (int)(this.omega / (Math.PI * 2));
            this.omega -= (double)n * (Math.PI * 2);
            this.omegaRevs += n;
        } else if (this.omega < 0.0) {
            n = 1 + (int)(-this.omega / (Math.PI * 2));
            this.omega += (double)n * (Math.PI * 2);
            this.omegaRevs -= n;
        }
        QuaternionDouble[] qAndRate = AttitudeConverter.heliotropicToQuaternions(lSun, super.getXiRef(), this.getNuMod4Pi(), this.getOmegaMod4Pi(), lSunDot, this.nuDot, this.omegaDot);
        return new ConcreteAttitude(tNow, qAndRate[0], qAndRate[1], true);
    }

    public void recomputeConstants() {
        this.xi = this.getXiRef();
        this.nu0 = this.getNuRef();
        double precRate = this.getTargetPrecessionRate();
        double sNom = NslUtil.calcSNom(this.xi, precRate);
        this.scanPerNs = this.getTargetScanPeriod();
        NslSun sun0 = new NslSun();
        sun0.setTime((double)this.getRefTime() * 1.1574074074074074E-14);
        this.lSunRef = sun0.getSolarLongitude();
        this.sx = FastMath.sin((double)this.xi);
        this.cx = FastMath.cos((double)this.xi);
        this.sx2 = this.sx * this.sx;
        this.sx4 = this.sx2 * this.sx2;
        this.cx2 = this.cx * this.cx;
        this.cx3 = this.cx * this.cx2;
        this.cx4 = this.cx2 * this.cx2;
        this.cx6 = this.cx4 * this.cx2;
        this.s1a = FastMath.sin((double)this.nu0);
        this.c1a = FastMath.cos((double)this.nu0);
        this.s2a = 2.0 * this.c1a * this.s1a;
        this.c2a = 2.0 * this.c1a * this.c1a - 1.0;
        this.s3a = this.s2a * this.c1a + this.c2a * this.s1a;
        this.c3a = this.c2a * this.c1a - this.s2a * this.s1a;
        this.s4a = 2.0 * this.c2a * this.s2a;
        this.c4a = 2.0 * this.c2a * this.c2a - 1.0;
        this.c5a = this.c2a * this.c3a - this.s2a * this.s3a;
        double s1 = 1.0 / sNom;
        double s2 = s1 * s1;
        double s3 = s1 * s2;
        double s4 = s2 * s2;
        double s5 = s2 * s3;
        double s6 = s2 * s4;
        this.c0v = s1 * (this.cx * this.c1a) + s2 * ((1.0 - 2.0 * this.cx2) * this.s2a / 8.0) + s3 * (this.cx3 * this.c1a / 4.0 + (this.cx - this.cx3) * this.c3a / 12.0) + s4 * ((1.0 - 2.0 * this.cx4) * this.s2a / 16.0 + (3.0 - 12.0 * this.cx2 + 8.0 * this.cx4) * this.s4a / 256.0);
        this.c1v = s1 * (-this.cx * this.c1a) + s2 * (this.cx2 * this.s2a / 2.0) + s3 * (this.cx * this.c1a / 16.0 + this.cx * this.c1a / 16.0 - (this.cx - 4.0 * this.cx3) * this.c3a / 16.0) + s4 * (-this.cx2 * this.s2a / 96.0 + this.cx4 * this.s2a / 8.0 + (7.0 * this.cx2 - 12.0 * this.cx4) * this.s4a / 96.0);
        this.s1v = s1 * (this.cx * this.s1a) + s2 * (this.cx2 / 2.0 + this.cx2 * this.c2a / 2.0) + s3 * ((this.cx - 4.0 * this.cx3) * this.s3a / 16.0) + s4 * (-(this.cx2 - 4.0 * this.cx4) / 16.0 + this.cx2 * this.c2a / 96.0 + this.cx4 * this.c2a / 8.0 + (7.0 * this.cx2 - 12.0 * this.cx4) * this.c4a / 96.0);
        this.c2v = s2 * (-(1.0 + 2.0 * this.cx2) * this.s2a / 8.0) + s3 * (-(this.cx + 2.0 * this.cx3) * this.c1a / 8.0 - (this.cx + 2.0 * this.cx3) * this.c3a / 8.0) + s4 * (-(3.0 - 8.0 * this.cx2 - 6.0 * this.cx4) * this.s2a / 48.0 - (1.0 - 4.0 * this.cx2 - 12.0 * this.cx4) * this.s4a / 64.0);
        this.s2v = s2 * (-(1.0 + 2.0 * this.cx2) * this.c2a / 8.0) + s3 * ((this.cx + 2.0 * this.cx3) * this.s1a / 8.0 + (this.cx + 2.0 * this.cx3) * this.s3a / 8.0) + s4 * ((1.0 + 4.0 * this.cx2 + 4.0 * this.cx4) / 64.0 - (3.0 - 8.0 * this.cx2 - 6.0 * this.cx4) * this.c2a / 48.0 - (1.0 - 4.0 * this.cx2 - 12.0 * this.cx4) * this.c4a / 64.0);
        this.c3v = s3 * ((5.0 * this.cx + 4.0 * this.cx3) * this.c3a / 48.0) + s4 * (-(5.0 * this.cx2 + 4.0 * this.cx4) * this.s2a / 32.0 - (5.0 * this.cx2 + 4.0 * this.cx4) * this.s4a / 32.0);
        this.s3v = s3 * (-(5.0 * this.cx + 4.0 * this.cx3) * this.s3a / 48.0) + s4 * (-(5.0 * this.cx2 + 4.0 * this.cx4) * this.c2a / 32.0 - (5.0 * this.cx2 + 4.0 * this.cx4) * this.c4a / 32.0);
        this.c4v = s4 * ((3.0 + 52.0 * this.cx2 + 24.0 * this.cx4) * this.s4a / 768.0);
        this.s4v = s4 * ((3.0 + 52.0 * this.cx2 + 24.0 * this.cx4) * this.c4a / 768.0);
        this.on = this.cx * (-1.0 + 0.5 * s2 * this.sx2 * (1.0 + s2 * (1.0 + 3.0 * this.cx2) / 4.0 + s4 * (1.0 + 2.0 * this.cx2 + 5.0 * this.cx4) / 8.0 + s6 * (5.0 + 9.0 * this.cx2 + 15.0 * this.cx4 + 35.0 * this.cx6) / 64.0));
        this.ocn = s1 * this.sx2 * (1.0 + s2 * (1.0 + 6.0 * this.cx2) / 8.0 + s4 * (3.0 + 12.0 * this.cx2 + 40.0 * this.cx4) / 64.0);
        this.os2n = -s2 * this.sx2 * this.cx * (1.0 + s2 * this.cx2) / 4.0;
        this.oc3n = s3 * this.sx2 * (1.0 - 2.0 * this.cx2 + s2 * (9.0 + 12.0 * this.cx2 - 40.0 * this.cx4) / 16.0) / 24.0;
        this.os4n = -s4 * this.sx4 * this.cx / 32.0;
        this.oc5n = s5 * this.sx2 * (3.0 - 12.0 * this.cx2 + 8.0 * this.cx4) / 640.0;
    }

    public double modFourPi(double angle) {
        double rev = FastMath.floor((double)(angle / (Math.PI * 4)));
        return angle - Math.PI * 4 * rev;
    }

    public double getNuFull() {
        return this.nu + (double)this.nuRevs * (Math.PI * 2);
    }

    public double getNuMod4Pi() {
        return this.nu + (double)(this.nuRevs % 2) * (Math.PI * 2);
    }

    public double getOmegaFull() {
        return this.omega + (double)this.omegaRevs * (Math.PI * 2);
    }

    public int getOmegaRevs() {
        return this.omegaRevs;
    }

    public double getOmegaMod4Pi() {
        return this.omega + (double)(this.omegaRevs % 2) * (Math.PI * 2);
    }

    public double getLSunRef() {
        return this.lSunRef;
    }

    public double getOmegaDot1() {
        return this.omegaDot;
    }
}

