/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gaia;

import gaiasky.util.Logger;
import gaiasky.util.gaia.BaseAttitudeDataServer;
import gaiasky.util.gaia.IAttitude;
import gaiasky.util.gaia.time.Gti;
import gaiasky.util.gaia.time.GtiList;

public abstract class NumericalAttitudeDataServer<A extends IAttitude>
extends BaseAttitudeDataServer<A> {
    protected GtiList gtis;

    public abstract void initialize();

    public boolean isValid(long t) {
        return this.gtis.inside(t) != null;
    }

    public GtiList getGtis() {
        GtiList gtisCopy = new GtiList();
        int nGtis = this.gtis.size();
        for (Gti gti : this.gtis) {
            long tStart = gti.getStart();
            long tEnd = gti.getEnd();
            try {
                gtisCopy.add(tStart, tEnd);
            }
            catch (RuntimeException e) {
                Logger.getLogger(this.getClass()).error(e);
            }
        }
        return gtisCopy;
    }

    public long getStartTime() {
        Gti gti = (Gti)this.gtis.get(0);
        return gti.getStart();
    }

    public long getStopTime() {
        Gti gti = (Gti)this.gtis.get(this.gtis.size() - 1);
        return gti.getEnd();
    }
}

