/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gaia;

import gaiasky.util.coord.NslSun;
import gaiasky.util.gaia.AnalyticalAttitudeDataServer;
import gaiasky.util.gaia.AttitudeConverter;
import gaiasky.util.gaia.ConcreteAttitude;
import gaiasky.util.gaia.Epsl;
import gaiasky.util.gaia.IAttitude;
import gaiasky.util.gaia.NslUtil;
import gaiasky.util.gaia.time.Duration;
import gaiasky.util.math.QuaternionDouble;
import net.jafama.FastMath;

public class TransitionScanningLaw
extends AnalyticalAttitudeDataServer {
    protected Duration ramp;
    protected double acc;
    protected double om0;
    protected double om1;
    protected double om2;
    protected double om3;
    protected double om4;
    protected double eps = 1.0E-9;

    public TransitionScanningLaw(Duration ramp) {
        this.setDefault();
        this.ramp = ramp;
        this.setInitialized(false);
    }

    public Epsl.Mode getMode() {
        Epsl.Mode mode = Epsl.Mode.PRECEDING;
        if (Math.cos(this.getNuRef()) < 0.0) {
            mode = Epsl.Mode.FOLLOWING;
        }
        return mode;
    }

    public TransitionScanningLaw setMode(Epsl.Mode mode) {
        this.setNuRef(mode);
        this.setInitialized(false);
        return this;
    }

    private void setNuRef(Epsl.Mode mode) {
        if (mode == Epsl.Mode.PRECEDING) {
            this.setNuRef(0.0);
        } else {
            this.setNuRef(Math.PI);
        }
    }

    public Duration getRampDuration() {
        return this.ramp;
    }

    public void initialize() {
        double xi = this.getXiRef();
        double sinXi = FastMath.sin((double)xi);
        double cosXi = FastMath.cos((double)xi);
        double Snom = NslUtil.calcSNom(xi, this.getTargetPrecessionRate());
        double rampDays = this.ramp.asDays();
        this.setNuRef(this.getMode());
        long tEnd = this.getRefTime() + this.ramp.asNanoSecs();
        NslSun sunDir = this.getNominalSunVector();
        sunDir.setTime(tEnd);
        double lSunDotEnd = sunDir.getSolarLongitudeDot();
        sunDir.setTime(this.getRefTime());
        double lSunDotRef = sunDir.getSolarLongitudeDot();
        double lSunDotDotRef = (lSunDotEnd - lSunDotRef) / rampDays;
        this.acc = 0.0;
        double sign = FastMath.cos((double)this.getNuRef());
        for (int i = 0; i < 10; ++i) {
            double delta = 0.5 * this.acc * rampDays * rampDays;
            double sinNu = sign * FastMath.sin((double)delta);
            this.acc = (Math.sqrt(Snom * Snom - 1.0 + sinNu * sinNu) + cosXi * sinNu) * lSunDotEnd / (sinXi * rampDays);
        }
        this.om0 = this.getOmegaRef();
        this.om1 = this.getTargetScanRate() * 4.84813681109536E-6 * 86400.0;
        this.om2 = -this.acc * cosXi / 2.0;
        this.om3 = -sign * this.acc * sinXi * lSunDotRef / 6.0;
        this.om4 = -sign * this.acc * sinXi * lSunDotDotRef / 8.0;
        this.setInitialized(true);
    }

    @Override
    public IAttitude getAttitudeNative(long time) {
        double t;
        double tNorm;
        if (!this.isInitialized()) {
            this.initialize();
        }
        if ((tNorm = (t = (double)(time - this.getRefTime()) * 1.0E-9 / 86400.0) / this.ramp.asDays()) < -this.eps || tNorm > 1.0 + this.eps) {
            throw new RuntimeException("TSL requested for time outside of ramp: t = " + t + " days, ramp = " + this.ramp.asDays() + " days");
        }
        double nu = this.getNuRef() + 0.5 * this.acc * t * t;
        double nuDot = this.acc * t;
        double omega = this.om0 + t * (this.om1 + t * (this.om2 + t * (this.om3 + t * this.om4)));
        double omegaDot = this.om1 + t * (2.0 * this.om2 + t * (3.0 * this.om3 + t * 4.0 * this.om4));
        NslSun sunDir = this.getNominalSunVector();
        sunDir.setTime(time);
        QuaternionDouble[] qr = AttitudeConverter.heliotropicToQuaternions(sunDir.getSolarLongitude(), this.getXiRef(), nu, omega, sunDir.getSolarLongitudeDot(), nuDot, omegaDot);
        return new ConcreteAttitude(time, qr[0], qr[1], false);
    }
}

