/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gaia.time;

import gaiasky.util.gaia.time.ConcreteDuration;
import gaiasky.util.gaia.time.Duration;
import net.jafama.FastMath;

public class Days
extends ConcreteDuration {
    public Days() {
    }

    public Days(double days) {
        this.value = days;
    }

    public static long asNanoSecs(double days) {
        return FastMath.round((double)(days * 8.64E13));
    }

    public static double asSecs(double days) {
        return days * 86400.0;
    }

    public static double asMins(double days) {
        return days * 1440.0;
    }

    public static double asRevs(double days) {
        return days * 4.0;
    }

    public static double asHours(double days) {
        return days * 24.0;
    }

    public static double asJulianYears(double days) {
        return days / 365.25;
    }

    @Override
    public Duration set(Duration d) {
        this.value = d.asDays();
        return this;
    }

    @Override
    public long asNanoSecs() {
        return FastMath.round((double)(this.value * 8.64E13));
    }

    @Override
    public double asSecs() {
        return this.value * 86400.0;
    }

    @Override
    public double asMins() {
        return this.value * 1440.0;
    }

    @Override
    public double asHours() {
        return this.value * 24.0;
    }

    @Override
    public double asRevs() {
        return this.value * 4.0;
    }

    @Override
    public double asDays() {
        return this.value;
    }

    @Override
    public double asJulianYears() {
        return this.value / 365.25;
    }

    @Override
    public Duration negate() {
        this.value = -this.value;
        return this;
    }

    @Override
    public Duration add(Duration d) {
        this.value += d.asDays();
        return this;
    }

    @Override
    public Duration sub(Duration d) {
        this.value -= d.asDays();
        return this;
    }

    public Days clone() {
        return new Days(this.value);
    }
}

