/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gaia.time;

import gaiasky.util.gaia.time.Duration;
import gaiasky.util.gaia.time.NanoSecs;
import java.util.Date;

public class Gti
implements Comparable<Gti> {
    private long start = -1L;
    private long end = -1L;

    public Gti(long start, long end) throws RuntimeException {
        if (start > end) {
            throw new RuntimeException("Start time is later than end time");
        }
        this.start = start;
        this.end = end;
    }

    public boolean equals(Object t) {
        if (t == null) {
            return false;
        }
        if (!(t instanceof Gti)) {
            return false;
        }
        Gti t1 = (Gti)t;
        return t1.getStart() == this.getStart() && t1.getEnd() == this.getEnd();
    }

    public int hashCode() {
        if (this.start >= 0L) {
            return (int)new NanoSecs(this.start).asSecs();
        }
        if (this.end >= 0L) {
            return (int)new NanoSecs(this.end).asSecs();
        }
        return 0;
    }

    public long getEnd() {
        return this.end;
    }

    public void setEnd(long end) throws RuntimeException {
        if (end < this.start) {
            throw new RuntimeException("End time is earlier than start time");
        }
        this.end = end;
    }

    public long getStart() {
        return this.start;
    }

    public void setStart(long start) throws RuntimeException {
        if (start > this.end) {
            throw new RuntimeException("Start time is later than end time");
        }
        this.start = start;
    }

    public Duration getDuration() {
        return new NanoSecs(this.end - this.start);
    }

    public boolean isInside(long time) {
        return !(time <= this.start && time != this.start || time >= this.end && time != this.end);
    }

    public boolean isLessThan(Gti i) {
        if (this.start != i.getStart()) {
            return this.start < i.getStart();
        }
        return this.end < i.getEnd();
    }

    @Override
    public int compareTo(Gti o) {
        if (this.start == o.getStart() && this.end == o.getEnd()) {
            return 0;
        }
        if (this.isLessThan(o)) {
            return -1;
        }
        return 1;
    }

    public String toString() {
        Date st = new Date();
        st.setTime(this.start / 1000000L);
        Date ed = new Date();
        ed.setTime(this.end / 1000000L);
        return String.valueOf(st) + " to " + String.valueOf(ed);
    }
}

