/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gaia.time;

import gaiasky.util.gaia.time.Gti;
import java.util.ArrayList;
import java.util.Collections;

public class GtiList
extends ArrayList<Gti> {
    private State state = State.UNKNOWN;

    public void add(long start, long end) throws RuntimeException {
        this.add(new Gti(start, end));
    }

    public Gti inside(long time) {
        for (Gti t : this) {
            if (!t.isInside(time)) continue;
            return t;
        }
        return null;
    }

    public void sortIt() {
        if (this.state != State.SORTED) {
            Collections.sort(this);
            this.state = State.SORTED;
        }
    }

    public void or(GtiList list) throws RuntimeException {
        this.addAll(list);
        this.state = State.UNKNOWN;
        this.reduce();
    }

    public void and(GtiList list) throws RuntimeException {
        GtiList l1 = this;
        GtiList l2 = list;
        l1.reduce();
        l2.reduce();
        int n1 = l1.size();
        int n2 = l2.size();
        GtiList resList = new GtiList();
        int actn2 = 0;
        for (int n = 0; n < n1; ++n) {
            while (actn2 < n2 && ((Gti)l2.get(actn2)).getEnd() < ((Gti)l1.get(n)).getStart()) {
                ++actn2;
            }
            while (actn2 < n2 && (((Gti)l2.get(actn2)).getStart() < ((Gti)l1.get(n)).getEnd() || ((Gti)l2.get(actn2)).getStart() == ((Gti)l1.get(n)).getEnd())) {
                long l1Start = ((Gti)l1.get(n)).getStart();
                long l1End = ((Gti)l1.get(n)).getEnd();
                long l2Start = ((Gti)l2.get(actn2)).getStart();
                long l2End = ((Gti)l2.get(actn2)).getEnd();
                Gti newGti = l1Start > l2Start ? new Gti(l1Start, l1Start) : new Gti(l2Start, l2Start);
                resList.add(newGti);
                if (l1End < l2End || l1End == l2End) {
                    newGti.setEnd(l1End);
                    break;
                }
                newGti.setEnd(l2End);
                ++actn2;
            }
            if (actn2 >= n2) break;
        }
        this.clear();
        this.addAll(resList);
    }

    public void reduce() throws RuntimeException {
        if (this.state == State.REDUCED) {
            return;
        }
        this.sortIt();
        int nGtis = this.size();
        if (nGtis == 0) {
            return;
        }
        int nNewGtis = 0;
        GtiList newGtiList = new GtiList();
        newGtiList.state = State.REDUCED;
        newGtiList.add((Gti)this.get(0));
        for (int n = 1; n < nGtis; ++n) {
            long newStart = ((Gti)this.get(n)).getStart();
            long newEnd = ((Gti)this.get(n)).getEnd();
            long end = ((Gti)newGtiList.get(nNewGtis)).getEnd();
            if (newStart > end) {
                newGtiList.add((Gti)this.get(n));
                ++nNewGtis;
                continue;
            }
            if (newEnd <= end) continue;
            ((Gti)newGtiList.get(nNewGtis)).setEnd(newEnd);
        }
        this.clear();
        this.addAll(newGtiList);
        this.state = State.REDUCED;
    }

    public double getOntime() {
        double time = 0.0;
        for (Gti i : this) {
            time += i.getDuration().asSecs();
        }
        return time;
    }

    public boolean isSorted() {
        return this.state == State.SORTED || this.state == State.REDUCED;
    }

    public boolean isReduced() {
        return this.state == State.REDUCED;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Gti i : this) {
            sb.append(i);
            sb.append('\n');
        }
        return sb.toString();
    }

    private static enum State {
        UNKNOWN,
        SORTED,
        REDUCED;

    }
}

