/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gaia.time;

import gaiasky.util.gaia.time.ConcreteDuration;
import gaiasky.util.gaia.time.Duration;
import net.jafama.FastMath;

public class Hours
extends ConcreteDuration {
    public Hours() {
    }

    public Hours(double hours) {
        this.value = hours;
    }

    public static long asNanoSecs(double hours) {
        return FastMath.round((double)(hours * 3.6E12));
    }

    public static double asSecs(double hours) {
        return hours * 3600.0;
    }

    public static double asMins(double hours) {
        return hours * 60.0;
    }

    public static double asRevs(double hours) {
        return hours / 6.0;
    }

    public static double asDays(double hours) {
        return hours / 24.0;
    }

    public static double asJulianYears(double hours) {
        return hours / 8766.0;
    }

    @Override
    public Duration set(Duration d) {
        this.value = d.asHours();
        return this;
    }

    @Override
    public long asNanoSecs() {
        return FastMath.round((double)(this.value * 3.6E12));
    }

    @Override
    public double asSecs() {
        return this.value * 3600.0;
    }

    @Override
    public double asMins() {
        return this.value * 60.0;
    }

    @Override
    public double asHours() {
        return this.value;
    }

    @Override
    public double asRevs() {
        return this.value / 6.0;
    }

    @Override
    public double asDays() {
        return this.value / 24.0;
    }

    @Override
    public double asJulianYears() {
        return this.value / 8766.0;
    }

    @Override
    public Duration add(Duration d) {
        this.value += d.asHours();
        return this;
    }

    @Override
    public Duration sub(Duration d) {
        this.value -= d.asHours();
        return this;
    }

    public Hours clone() {
        return new Hours(this.value);
    }
}

