/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gaia.time;

import gaiasky.util.gaia.time.ConcreteDuration;
import gaiasky.util.gaia.time.Duration;
import net.jafama.FastMath;

public class JulianYears
extends ConcreteDuration {
    public JulianYears() {
    }

    public JulianYears(double years) {
        this.value = years;
    }

    public static long asNanoSecs(double years) {
        return FastMath.round((double)(years * 3.15576E16));
    }

    public static double asSecs(double years) {
        return years * 3.15576E7;
    }

    public static double asMins(double years) {
        return years * 525960.0;
    }

    public static double asHours(double years) {
        return years * 8766.0;
    }

    public static double asRevs(double years) {
        return years * 1461.0;
    }

    public static double asDays(double years) {
        return years * 365.25;
    }

    @Override
    public Duration set(Duration d) {
        this.value = d.asJulianYears();
        return this;
    }

    @Override
    public long asNanoSecs() {
        return FastMath.round((double)(this.value * 3.15576E16));
    }

    @Override
    public double asSecs() {
        return this.value * 3.15576E7;
    }

    @Override
    public double asMins() {
        return this.value * 525960.0;
    }

    @Override
    public double asHours() {
        return this.value * 8766.0;
    }

    @Override
    public double asRevs() {
        return this.value * 1461.0;
    }

    @Override
    public double asDays() {
        return this.value * 365.25;
    }

    @Override
    public double asJulianYears() {
        return this.value;
    }

    @Override
    public Duration add(Duration d) {
        this.value += d.asJulianYears();
        return this;
    }

    @Override
    public Duration sub(Duration d) {
        this.value -= d.asJulianYears();
        return this;
    }

    public JulianYears clone() {
        return new JulianYears(this.value);
    }
}

