/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gaia.time;

import gaiasky.util.gaia.time.ConcreteDuration;
import gaiasky.util.gaia.time.Duration;
import net.jafama.FastMath;

public class Mins
extends ConcreteDuration {
    public Mins() {
    }

    public Mins(double mins) {
        this.value = mins;
    }

    public static long asNanoSecs(double mins) {
        return FastMath.round((double)(mins * 6.0E10));
    }

    public static double asSecs(double mins) {
        return mins * 60.0;
    }

    public static double asHours(double mins) {
        return mins / 60.0;
    }

    public static double asRevs(double mins) {
        return mins / 360.0;
    }

    public static double asDays(double mins) {
        return mins / 1440.0;
    }

    public static double asJulianYears(double mins) {
        return mins / 525960.0;
    }

    @Override
    public Duration set(Duration d) {
        this.value = d.asMins();
        return this;
    }

    @Override
    public long asNanoSecs() {
        return FastMath.round((double)(this.value * 6.0E10));
    }

    @Override
    public double asSecs() {
        return this.value * 60.0;
    }

    @Override
    public double asMins() {
        return this.value;
    }

    @Override
    public double asHours() {
        return this.value / 60.0;
    }

    @Override
    public double asRevs() {
        return this.value / 360.0;
    }

    @Override
    public double asDays() {
        return this.value / 1440.0;
    }

    @Override
    public double asJulianYears() {
        return this.value / 525960.0;
    }

    @Override
    public Duration add(Duration d) {
        this.value += d.asMins();
        return this;
    }

    @Override
    public Duration sub(Duration d) {
        this.value -= d.asMins();
        return this;
    }

    public Mins clone() {
        return new Mins(this.value);
    }
}

