/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gaia.time;

import gaiasky.util.gaia.time.ConcreteDuration;
import gaiasky.util.gaia.time.Duration;
import net.jafama.FastMath;

public class NanoSecs
extends ConcreteDuration {
    private long ns;

    public NanoSecs() {
    }

    public NanoSecs(long ns) {
        this.ns = ns;
    }

    public static double asSecs(long nanoSecs) {
        return (double)nanoSecs / 1.0E9;
    }

    public static double asMins(long nanoSecs) {
        return (double)nanoSecs / 6.0E10;
    }

    public static double asHours(long nanoSecs) {
        return (double)nanoSecs / 3.6E12;
    }

    public static double asRevs(long nanoSecs) {
        return (double)nanoSecs / 2.16E13;
    }

    public static double asDays(long nanoSecs) {
        return (double)nanoSecs / 8.64E13;
    }

    public static double asJulianYears(long nanoSecs) {
        return (double)nanoSecs / 3.15576E16;
    }

    @Override
    public Duration set(Duration d) {
        this.ns = d.asNanoSecs();
        return this;
    }

    @Override
    public long asNanoSecs() {
        return this.ns;
    }

    @Override
    public double asSecs() {
        return (double)this.ns / 1.0E9;
    }

    @Override
    public double asMins() {
        return (double)this.ns / 6.0E10;
    }

    @Override
    public double asHours() {
        return (double)this.ns / 3.6E12;
    }

    @Override
    public double asRevs() {
        return (double)this.ns / 2.16E13;
    }

    @Override
    public double asDays() {
        return (double)this.ns / 8.64E13;
    }

    @Override
    public double asJulianYears() {
        return (double)this.ns / 3.15576E16;
    }

    @Override
    public NanoSecs negate() {
        this.ns = -this.ns;
        return this;
    }

    @Override
    public Duration add(Duration d) {
        this.ns += d.asNanoSecs();
        return this;
    }

    @Override
    public Duration sub(Duration d) {
        this.ns -= d.asNanoSecs();
        return this;
    }

    @Override
    public Duration mult(double s) {
        this.ns = FastMath.round((double)((double)this.ns * s));
        return this;
    }

    public NanoSecs clone() {
        return new NanoSecs(this.ns);
    }
}

