/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gaia.time;

import gaiasky.util.gaia.time.ConcreteDuration;
import gaiasky.util.gaia.time.Duration;
import net.jafama.FastMath;

public class Revs
extends ConcreteDuration {
    public Revs() {
    }

    public Revs(double revs) {
        this.value = revs;
    }

    public static long asNanoSecs(double revs) {
        return FastMath.round((double)(revs * 2.16E13));
    }

    public static double asSecs(double revs) {
        return revs * 21600.0;
    }

    public static double asMins(double revs) {
        return revs * 360.0;
    }

    public static double asHours(double revs) {
        return revs * 6.0;
    }

    public static double asDays(double revs) {
        return revs / 4.0;
    }

    public static double asJulianYears(double revs) {
        return revs / 1461.0;
    }

    @Override
    public Duration set(Duration d) {
        this.value = d.asRevs();
        return this;
    }

    @Override
    public long asNanoSecs() {
        return FastMath.round((double)(this.value * 2.16E13));
    }

    @Override
    public double asSecs() {
        return this.value * 21600.0;
    }

    @Override
    public double asMins() {
        return this.value * 360.0;
    }

    @Override
    public double asHours() {
        return this.value * 6.0;
    }

    @Override
    public double asRevs() {
        return this.value;
    }

    @Override
    public double asDays() {
        return this.value / 4.0;
    }

    @Override
    public double asJulianYears() {
        return this.value / 1461.0;
    }

    @Override
    public Duration add(Duration d) {
        this.value += d.asRevs();
        return this;
    }

    @Override
    public Duration sub(Duration d) {
        this.value -= d.asRevs();
        return this;
    }

    public Revs clone() {
        return new Revs(this.value);
    }
}

