/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gaia.time;

import gaiasky.util.gaia.time.ConcreteDuration;
import gaiasky.util.gaia.time.Duration;
import net.jafama.FastMath;

public class Secs
extends ConcreteDuration {
    public Secs() {
    }

    public Secs(double secs) {
        this.value = secs;
    }

    public static long asNanoSecs(double secs) {
        return FastMath.round((double)(secs * 1.0E9));
    }

    public static double asMins(double secs) {
        return secs / 60.0;
    }

    public static double asHours(double secs) {
        return secs / 3600.0;
    }

    public static double asRevs(double secs) {
        return secs / 21600.0;
    }

    public static double asDays(double secs) {
        return secs / 86400.0;
    }

    public static double asJulianYears(double secs) {
        return secs / 3.15576E7;
    }

    @Override
    public Duration set(Duration d) {
        this.value = d.asSecs();
        return this;
    }

    @Override
    public long asNanoSecs() {
        return FastMath.round((double)(this.value * 1.0E9));
    }

    @Override
    public double asSecs() {
        return this.value;
    }

    @Override
    public double asMins() {
        return this.value / 60.0;
    }

    @Override
    public double asHours() {
        return this.value / 3600.0;
    }

    @Override
    public double asRevs() {
        return this.value / 21600.0;
    }

    @Override
    public double asDays() {
        return this.asSecs() / 86400.0;
    }

    @Override
    public double asJulianYears() {
        return this.value / 3.15576E7;
    }

    @Override
    public Duration add(Duration d) {
        this.value += d.asSecs();
        return this;
    }

    @Override
    public Duration sub(Duration d) {
        this.value -= d.asSecs();
        return this;
    }

    public Secs clone() {
        return new Secs(this.value);
    }
}

