/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gaia.time;

import gaiasky.util.gaia.time.TimeContext;

public class TimeMediator {
    static TimeMediator[] mediators = new TimeMediator[]{new TimeMediator(TimeContext.TCB, TimeContext.TCB), new TimeMediator(TimeContext.TCB, TimeContext.OBMT), new TimeMediator(TimeContext.OBMT, TimeContext.TCB), new TimeMediator(TimeContext.OBMT, TimeContext.OBMT)};
    protected TimeConverter converter;

    public TimeMediator(TimeContext nat, TimeContext req) {
        this.setTimeContext(nat, req);
    }

    public static TimeMediator getTimeMediator(TimeContext nat, TimeContext req) {
        return mediators[nat.getIndex() * TimeContext.values().length + req.getIndex()];
    }

    public long convert(long t) {
        return this.converter.convert(t);
    }

    public void setTimeContext(TimeContext nat, TimeContext req) {
        this.converter = req == TimeContext.OBMT && nat == TimeContext.OBMT ? new ObmtToObmt() : new TcbToTcb();
    }

    public static interface TimeConverter {
        public long convert(long var1);
    }

    private static class ObmtToObmt
    implements TimeConverter {
        private ObmtToObmt() {
        }

        @Override
        public long convert(long t) {
            return t;
        }
    }

    private static class TcbToTcb
    implements TimeConverter {
        private TcbToTcb() {
        }

        @Override
        public long convert(long t) {
            return t;
        }
    }
}

