/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gaia.utils;

import gaiasky.util.Logger;

public class AttitudeUtils {
    public static int findLeftIndex(long x, long[] xa, int splineOrder) {
        if (x >= xa[xa.length - 1]) {
            return xa.length - 1;
        }
        if (x < xa[0]) {
            return -1;
        }
        double attitudeTimeIncrement = xa[splineOrder + 1] - xa[splineOrder];
        int estXPos = (int)((double)(x - xa[0]) / attitudeTimeIncrement) + splineOrder + 1;
        if (estXPos >= xa.length) {
            estXPos = xa.length - 1;
        }
        if (estXPos < 0) {
            estXPos = 0;
        }
        if (xa[estXPos] == x) {
            while (xa[estXPos] == x) {
                --estXPos;
            }
        } else if (xa[estXPos] > x) {
            while (xa[estXPos] > x) {
                --estXPos;
            }
        } else {
            while (estXPos + 1 < xa.length && xa[estXPos + 1] < x) {
                ++estXPos;
            }
        }
        return estXPos;
    }

    public static int findLeftIndexVar(long x, long[] xa, int splineOrder) {
        if (x == xa[xa.length - 1]) {
            return xa.length - 2;
        }
        return AttitudeUtils.findLeftIndex(x, xa, splineOrder);
    }

    public static int findLeftIndexBSpline(long x, long[] xa) {
        if (x > xa[xa.length - 1]) {
            return -1;
        }
        if (x == xa[xa.length - 1]) {
            int left;
            for (left = xa.length - 1; left > 1 && xa[left] - xa[xa.length - 1] == 0L; --left) {
            }
            return left;
        }
        if (x < xa[0]) {
            return -1;
        }
        int klo = 0;
        int khi = xa.length - 1;
        while (khi - klo > 1) {
            int k = khi + klo >>> 1;
            if (xa[k] > x) {
                khi = k;
                continue;
            }
            klo = k;
        }
        if (xa[klo] == x) {
            if (xa[0] == x) {
                while (klo < xa.length - 1 && xa[klo] - xa[klo + 1] == 0L) {
                    ++klo;
                }
                if (xa[klo] == x && xa[klo + 1] == x) {
                    ++klo;
                }
            } else {
                while (klo > 1 && xa[klo] - xa[klo - 1] == 0L) {
                    --klo;
                }
                if (xa[klo] == x && xa[klo + 1] == x) {
                    --klo;
                }
            }
        }
        return klo;
    }

    public static int findLeftIndexBisection(long x, long[] xa) {
        int klo = 0;
        int khi = xa.length - 1;
        if (x > xa[khi] || x == xa[khi]) {
            return khi;
        }
        if (x < xa[klo]) {
            return -1;
        }
        while (khi - klo > 1) {
            int k = khi + klo >>> 1;
            if (xa[k] > x) {
                khi = k;
                continue;
            }
            klo = k;
        }
        return klo;
    }

    public static int findLeftIndexBisectionVar(long x, long[] xa) {
        if (x == xa[xa.length - 1]) {
            return xa.length - 2;
        }
        return AttitudeUtils.findLeftIndexBisection(x, xa);
    }

    public static int findLeftIndexBisection(int x, int[] xa) {
        int klo = 0;
        int khi = xa.length - 1;
        if (x > xa[khi] || x == xa[khi]) {
            return khi;
        }
        if (x < xa[klo]) {
            return -1;
        }
        while (khi - klo > 1) {
            int k = khi + klo >>> 1;
            if (xa[k] > x) {
                khi = k;
                continue;
            }
            klo = k;
        }
        return klo;
    }

    public static int findLeftIndexBisectionVar(int x, int[] xa) {
        if (x == xa[xa.length - 1]) {
            return xa.length - 2;
        }
        return AttitudeUtils.findLeftIndexBisection(x, xa);
    }

    public static void calcBsplines(long x, long[] tau, int splineOrder, int leftIndex, double[] b0, double[] b1) throws RuntimeException {
        if (leftIndex < splineOrder - 2 || leftIndex > tau.length - splineOrder) {
            throw new RuntimeException("leftIndex (" + leftIndex + ") is not within valid bounds [M-2, N]=[" + (splineOrder - 2) + ", " + (tau.length - splineOrder) + "]");
        }
        long[] deltal = new long[splineOrder];
        long[] deltar = new long[splineOrder];
        b0[0] = 1.0;
        b1[0] = 0.0;
        for (int i = 0; i < splineOrder - 1; ++i) {
            int j;
            deltar[i] = tau[leftIndex + i + 1] - x;
            deltal[i] = x - tau[leftIndex - i];
            double s0 = 0.0;
            double s1 = 0.0;
            for (j = 0; j <= i; ++j) {
                long dr = deltar[j];
                long dl = deltal[i - j];
                double t0 = b0[j] / (double)(dr + dl);
                double t1 = b1[j] / (double)(dr + dl);
                b0[j] = s0 + (double)dr * t0;
                b1[j] = s1 - t0 + (double)dr * t1;
                s0 = (double)dl * t0;
                s1 = t0 + (double)dl * t1;
            }
            j = i + 1;
            b0[j] = s0;
            b1[j] = s1;
        }
    }

    @Deprecated
    public static double[] smallAngularDifferences(double[] q0, double[] q1) {
        double[] dq = new double[4];
        double EPS = 0.001;
        int maxk = 1;
        block0: for (int k = 0; k < maxk; ++k) {
            for (int i = 0; i < 4; ++i) {
                dq[i] = q1[i] - q0[i];
                if (!(Math.abs(dq[i]) > 0.001)) continue;
                for (int j = 0; j < 4; ++j) {
                    q1[j] = -q1[j];
                }
                maxk = 2;
                if (k != 1) continue block0;
                Logger.getLogger(AttitudeUtils.class).warn("out of small angle approximation: insignificant result");
                continue block0;
            }
        }
        return new double[]{2.0 * (dq[0] * q0[3] + dq[1] * q0[2] - dq[2] * q0[1] - dq[3] * q0[0]), 2.0 * (-dq[0] * q0[2] + dq[1] * q0[3] + dq[2] * q0[0] - dq[3] * q0[1]), 2.0 * (dq[0] * q0[1] - dq[1] * q0[0] + dq[2] * q0[3] - dq[3] * q0[2])};
    }

    public static long[] insertKnots(long[] oldKnots, long[] tInsert, int multiplicity, int splineOrder) {
        int nDegsFreedomN = oldKnots.length - splineOrder;
        long[] knots = new long[nDegsFreedomN + multiplicity * tInsert.length + splineOrder];
        int count = 0;
        knots[0] = oldKnots[0];
        for (int k = 1; k < oldKnots.length; ++k) {
            long knot = oldKnots[k];
            for (int i = 0; i < tInsert.length; ++i) {
                long insertTime = tInsert[i];
                if (insertTime >= knot || oldKnots[k - 1] >= insertTime) continue;
                for (int m = 0; m < multiplicity; ++m) {
                    knots[k + count] = insertTime;
                    ++count;
                }
            }
            knots[k + count] = knot;
        }
        return knots;
    }

    public static KnotsAndSplines insertKnotsAndSplines(KnotsAndSplines old, long[] tInsert, int multiplicity, int splineOrder) {
        int nDegsFreedomN = old.knots.length - splineOrder;
        KnotsAndSplines out = new KnotsAndSplines(new long[nDegsFreedomN + multiplicity * tInsert.length + splineOrder], new double[4][nDegsFreedomN + multiplicity * tInsert.length]);
        int count = 0;
        out.knots[0] = old.knots[0];
        for (int j = 0; j < 4; ++j) {
            out.splines[j][0] = old.splines[j][0];
        }
        for (int k = 1; k < old.knots.length; ++k) {
            long knot = old.knots[k];
            for (int i = 0; i < tInsert.length; ++i) {
                long insertTime = tInsert[i];
                if (insertTime >= knot || old.knots[k - 1] >= insertTime) continue;
                for (int m = 0; m < multiplicity; ++m) {
                    out.knots[k + count] = insertTime;
                    for (int j = 0; j < 4; ++j) {
                        out.splines[j][k + count] = 0.0;
                    }
                    ++count;
                }
            }
            out.knots[k + count] = knot;
            if (k >= old.knots.length - splineOrder) continue;
            for (int j = 0; j < 4; ++j) {
                out.splines[j][k + count] = old.splines[j][k];
            }
        }
        return out;
    }

    public static double[] insertElements(double[] oldElements, long[] knots, long[] tInsert, int multiplicity, int splineOrder) {
        int nDegsFreedomN = knots.length - splineOrder;
        double[] elements = new double[nDegsFreedomN + multiplicity * tInsert.length + splineOrder - 1];
        int count = 0;
        elements[0] = oldElements[0];
        for (int k = 1; k < knots.length; ++k) {
            long knot = knots[k];
            for (int i = 0; i < tInsert.length; ++i) {
                long insertTime = tInsert[i];
                if (insertTime >= knot || knots[k - 1] >= insertTime) continue;
                for (int m = 0; m < multiplicity; ++m) {
                    elements[k + count] = 0.0;
                    ++count;
                }
            }
            if (k + count >= elements.length) continue;
            elements[k + count] = oldElements[k];
        }
        return elements;
    }

    public static class KnotsAndSplines {
        public long[] knots;
        public double[][] splines;

        public KnotsAndSplines(long[] knots, double[][] splines) {
            this.knots = knots;
            this.splines = splines;
        }
    }
}

