/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gaia.utils;

import gaiasky.util.gaia.utils.Area;
import gaiasky.util.gaia.utils.Place;
import net.jafama.FastMath;

public class CircleArea
implements Area {
    private static final double piHalf = 1.5707963267948966;
    private static final double squareDegreesOfSphere = 41252.96124941927;
    private final Place centre;
    private final double radius;

    public CircleArea(Place c, double r) {
        this.centre = new Place(c);
        this.radius = r;
    }

    @Override
    public double altitude(Place pole) {
        double absLat = FastMath.abs((double)(1.5707963267948966 - pole.getAngleTo(this.centre)));
        return FastMath.max((double)(absLat - this.radius), (double)0.0);
    }

    @Override
    public boolean contains(Place p) {
        return p.getAngleTo(this.centre) < this.radius;
    }

    @Override
    public Place getMidPoint() {
        return new Place(this.centre);
    }

    @Override
    public double getWeight() {
        double w = this.radius <= 0.0 ? 0.0 : (this.radius < 1.0 ? 0.5 * FastMath.pow((double)Math.sin(this.radius), (double)2.0) / (1.0 + FastMath.cos((double)this.radius)) : (this.radius < Math.PI ? 0.5 * (1.0 - FastMath.cos((double)this.radius)) : 1.0));
        return w;
    }

    public Place getCentre() {
        return this.centre;
    }

    public double getRadius() {
        return this.radius;
    }

    public double getSquareDegrees() {
        return this.getWeight() * 41252.96124941927;
    }
}

