/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gaia.utils;

import gaiasky.util.gaia.utils.Area;
import gaiasky.util.gaia.utils.CircleArea;
import gaiasky.util.gaia.utils.Place;
import gaiasky.util.math.Vector3D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import net.jafama.FastMath;

public class ComplexArea
implements Area {
    private static final double piHalf = 1.5707963267948966;
    private final Collection<Area> listOfAreas = new ArrayList<Area>();
    private String name;

    public void add(Area a) {
        this.listOfAreas.add(a);
    }

    @Override
    public double altitude(Place spinAxisPlace) {
        double alt = Math.PI;
        for (Area a : this.listOfAreas) {
            alt = FastMath.min((double)alt, (double)a.altitude(spinAxisPlace));
        }
        return alt;
    }

    @Override
    public boolean contains(Place p) {
        boolean isIn = false;
        for (Area a : this.listOfAreas) {
            isIn = isIn || a.contains(p);
        }
        return isIn;
    }

    @Override
    public Place getMidPoint() {
        Vector3D sum = new Vector3D();
        for (Area a : this.listOfAreas) {
            sum.scaleAdd(a.getWeight(), a.getMidPoint().getDirection());
        }
        if (sum.len() == 0.0) {
            sum.set(0.0, 0.0, 1.0);
        }
        return new Place(sum);
    }

    @Override
    public double getWeight() {
        double sum = 0.0;
        for (Area a : this.listOfAreas) {
            sum += a.getWeight();
        }
        return sum;
    }

    public Place getRandomPlace(Random rnd) {
        Place centre = new Place(this.getMidPoint());
        double radius = 1.5707963267948966 - this.altitude(centre);
        Place p = new Place(rnd);
        p.moveToRandom(rnd, centre, radius);
        while (!this.contains(p)) {
            p.moveToRandom(rnd, centre, radius);
        }
        return p;
    }

    public double getSquareDegrees() {
        Place centre = new Place(this.getMidPoint());
        double radius = 1.5707963267948966 - this.altitude(centre);
        CircleArea circle = new CircleArea(centre, radius);
        int nMC = 1000000;
        int in = 0;
        Random rnd = new Random(0L);
        Place p = new Place();
        for (int i = 0; i < nMC; ++i) {
            p.moveToRandom(rnd, centre, radius);
            if (!this.contains(p)) continue;
            ++in;
        }
        return circle.getSquareDegrees() * ((double)in / (double)nMC);
    }

    public Collection<Area> getListOfAreas() {
        return this.listOfAreas;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String str) {
        this.name = str;
    }
}

