/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gaia.utils;

import gaiasky.util.math.MathUtilsDouble;
import gaiasky.util.math.QuaternionDouble;

public class Interpolator {
    protected static double dtMin = 2.3148148148148148E-7;

    public static double[] hermite3(double x, double x0, double y0, double yp0, double x1, double y1, double yp1) {
        double dx = x1 - x0;
        double ddx = (yp0 + yp1 - 2.0 * (y1 - y0) / dx) / dx;
        double c = ((yp1 - yp0) / dx - 3.0 * ddx) / 2.0;
        double d = ddx / dx;
        double t = x - x0;
        double yInt = y0 + t * (yp0 + t * (c + t * d));
        double ypInt = yp0 + t * (2.0 * c + t * 3.0 * d);
        return new double[]{yInt, ypInt};
    }

    public static double[] linear(double x, double x0, double y0, double x1, double y1) {
        double y = MathUtilsDouble.lint(x, x0, x1, y0, y1);
        double yprima = (y1 - y0) / (x1 - x0);
        return new double[]{y, yprima};
    }

    public static QuaternionDouble[] qHermiteAverage(double ta, double tb, double[] t, int indx, QuaternionDouble[] q, QuaternionDouble[] qDot) {
        QuaternionDouble qDotAve;
        QuaternionDouble qAve;
        if (tb - ta < dtMin) {
            double tm = (ta + tb) / 2.0;
            int left = Interpolator.getLeftVar(tm, t, indx);
            qAve = Interpolator.qEval(tm, t, q, qDot, left, Kind.VAL);
            qDotAve = Interpolator.qEval(tm, t, q, qDot, left, Kind.DER);
        } else {
            int lefta = Interpolator.getLeftVar(ta, t, indx);
            QuaternionDouble qa = Interpolator.qEval(ta, t, q, qDot, lefta, Kind.INT);
            int leftb = Interpolator.getLeftVar(tb, t, indx);
            QuaternionDouble qb = Interpolator.qEval(tb, t, q, qDot, leftb, Kind.INT);
            qAve = qb.mulAdd(qa, -1.0);
            for (int left = lefta; left < leftb; ++left) {
                double dth = (t[left + 1] - t[left]) / 2.0;
                qAve.mulAdd(q[left], dth).mulAdd(q[left + 1], dth).mulAdd(qDot[left], dth * dth / 3.0).mulAdd(qDot[left + 1], -dth * dth / 3.0);
            }
            qAve.mul(1.0 / (tb - ta));
            qa = Interpolator.qEval(ta, t, q, qDot, lefta, Kind.VAL);
            qb = Interpolator.qEval(tb, t, q, qDot, leftb, Kind.VAL);
            qDotAve = qb.mulAdd(qa, -1.0).mul(1.0 / (tb - ta));
        }
        return new QuaternionDouble[]{qAve, qDotAve};
    }

    public static QuaternionDouble qEval(double tx, double[] t, QuaternionDouble[] q, QuaternionDouble[] qDot, int left, Kind kind) {
        double[] p;
        double dt = t[left + 1] - t[left];
        double x = (tx - t[left]) / dt;
        switch (kind.ordinal()) {
            case 0: {
                p = Interpolator.interPolDer(x);
                p[0] = p[0] / dt;
                p[1] = p[1] / dt;
                break;
            }
            case 1: {
                p = Interpolator.interPolVal(x);
                p[2] = p[2] * dt;
                p[3] = p[3] * dt;
                break;
            }
            case 2: {
                p = Interpolator.interPolInt(x);
                p[0] = p[0] * dt;
                p[1] = p[1] * dt;
                p[2] = p[2] * (dt * dt);
                p[3] = p[3] * (dt * dt);
                break;
            }
            default: {
                p = null;
            }
        }
        return q[left].cpy().mul(p[0]).mulAdd(q[left + 1], p[1]).mulAdd(qDot[left], p[2]).mulAdd(qDot[left + 1], p[3]);
    }

    public static int getLeft(double ta, double[] t, int indx) {
        int left = indx;
        while (t[left] > ta) {
            --left;
        }
        while (t[left + 1] <= ta) {
            ++left;
        }
        return left;
    }

    public static int getLeftVar(double ta, double[] t, int indx) {
        if (ta == t[t.length - 1]) {
            return t.length - 2;
        }
        return Interpolator.getLeft(ta, t, indx);
    }

    protected static double[] interPolVal(double x) {
        double a1 = x * x * (3.0 - 2.0 * x);
        double a0 = 1.0 - a1;
        double b = x * (x - 1.0);
        double b1 = x * b;
        double b0 = b1 - b;
        return new double[]{a0, a1, b0, b1};
    }

    protected static double[] interPolDer(double x) {
        double ap1 = 6.0 * x * (1.0 - x);
        double ap0 = -ap1;
        double bp1 = x * (3.0 * x - 2.0);
        double bp0 = bp1 + 1.0 - 2.0 * x;
        return new double[]{ap0, ap1, bp0, bp1};
    }

    protected static double[] interPolInt(double x) {
        double x2 = x * x;
        double x3 = x2 * x;
        double A1 = x3 * (1.0 - 0.5 * x);
        double A0 = x - A1;
        double B1 = x3 * (0.25 * x - 0.3333333333333333);
        double B0 = B1 + x2 * (0.5 - 0.3333333333333333 * x);
        return new double[]{A0, A1, B0, B1};
    }

    @Deprecated
    public static int findLeftIndex(long[] xa, int xaLength, long x) {
        int kLo = 0;
        int kHi = xaLength - 1;
        if (x > xa[kHi] || x == xa[kHi]) {
            return kHi;
        }
        if (x < xa[kLo]) {
            return -1;
        }
        while (kHi - kLo > 1) {
            int k = kHi + kLo >>> 1;
            if (xa[k] > x) {
                kHi = k;
                continue;
            }
            kLo = k;
        }
        return kLo;
    }

    public static enum Kind {
        DER,
        VAL,
        INT;

    }
}

