/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gaia.utils;

import gaiasky.util.coord.Coordinates;
import gaiasky.util.math.Vector3D;
import java.util.Random;
import net.jafama.FastMath;

public class Place {
    protected Vector3D dirICRS = null;
    protected boolean haveAngles = false;
    protected double alpha;
    protected double delta;

    public Place() {
        this.dirICRS = new Vector3D(1.0, 0.0, 0.0);
        this.haveAngles = false;
    }

    public Place(Vector3D r) {
        this.dirICRS = r.cpy().nor();
        this.haveAngles = false;
    }

    public Place(double rightAscension, double declination) {
        this.dirICRS = new Vector3D();
        Coordinates.sphericalToCartesian(rightAscension, declination, 1.0, this.dirICRS);
        this.alpha = rightAscension;
        this.delta = declination;
        this.haveAngles = true;
    }

    public Place(Random rnd) {
        this.dirICRS = new Vector3D(rnd.nextGaussian(), rnd.nextGaussian(), rnd.nextGaussian()).nor();
        this.haveAngles = false;
    }

    public Place(Place p) {
        this.dirICRS = p.getDirection();
        this.haveAngles = false;
    }

    public Vector3D getDirection() {
        return this.dirICRS.cpy();
    }

    public Place setDirection(Vector3D r) {
        this.dirICRS = r.cpy().nor();
        this.haveAngles = false;
        return this;
    }

    public double getAlpha() {
        if (!this.haveAngles) {
            this.calcAngles();
        }
        return this.alpha;
    }

    public double getDelta() {
        if (!this.haveAngles) {
            this.calcAngles();
        }
        return this.delta;
    }

    public Place setAngles(double rightAscension, double declination) {
        Coordinates.sphericalToCartesian(rightAscension, declination, 1.0, this.dirICRS);
        this.alpha = rightAscension;
        this.delta = declination;
        this.haveAngles = true;
        return this;
    }

    public double getAngleTo(Place p) {
        Vector3D v1 = this.getDirection();
        Vector3D v2 = p.getDirection();
        Vector3D sum = v1.cpy().add(v2);
        Vector3D dif = v1.sub(v2);
        return 2.0 * FastMath.atan2((double)dif.len(), (double)sum.len());
    }

    public String toString() {
        return "Place at (alpha, delta) = (" + this.getAlpha() + ", " + this.getDelta() + ")";
    }

    public Place moveToRandom(Random rnd) {
        double x = rnd.nextGaussian();
        double y = rnd.nextGaussian();
        double z = rnd.nextGaussian();
        this.dirICRS = new Vector3D(x, y, z).nor();
        this.haveAngles = false;
        return this;
    }

    public Place moveToRandom(Random rnd, Place centre, double radius) {
        Vector3D pole = new Vector3D(0.0, 0.0, 1.0);
        Vector3D c = centre.getDirection();
        Vector3D p = pole.cpy().crs(c);
        double pNorm = p.len();
        if (pNorm < 0.1) {
            pole.set(1.0, 0.0, 0.0);
            p = pole.cpy().crs(c);
            pNorm = p.len();
        }
        p.scl(1.0 / pNorm);
        Vector3D q = c.cpy().crs(p);
        double tMax = this.getWeight(radius);
        double t = tMax * rnd.nextDouble();
        double phi = Math.PI * 2 * rnd.nextDouble();
        double s = 2.0 * FastMath.sqrt((double)(t * (1.0 - t)));
        double x = s * FastMath.cos((double)phi);
        double y = s * FastMath.sin((double)phi);
        double z = 1.0 - 2.0 * t;
        this.dirICRS = c.scl(z).scaleAdd(x, p).scaleAdd(y, q);
        this.haveAngles = false;
        return this;
    }

    private double getWeight(double radius) {
        double w = radius <= 0.0 ? 0.0 : (radius < 1.0 ? 0.5 * FastMath.pow((double)Math.sin(radius), (double)2.0) / (1.0 + FastMath.cos((double)radius)) : (radius < Math.PI ? 0.5 * (1.0 - FastMath.cos((double)radius)) : 1.0));
        return w;
    }

    protected void calcAngles() {
        Vector3D aux = new Vector3D();
        Coordinates.cartesianToSpherical(this.dirICRS, aux);
        this.alpha = aux.x;
        this.delta = aux.y;
        this.haveAngles = true;
    }
}

