/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gaia.utils;

import gaiasky.util.gaia.utils.DiffnFunctionNs;
import net.jafama.FastMath;

public class RungeKuttaNs {
    public static double[] fourthOrder(DiffnFunctionNs g, long tOld, double[] y0, long tNew, long tStepMax, long tUnit) {
        double half = 0.5;
        double third = 0.3333333333333333;
        double sixth = 0.16666666666666666;
        int nEqs = y0.length;
        double[] k1 = new double[nEqs];
        double[] k2 = new double[nEqs];
        double[] k3 = new double[nEqs];
        double[] y = new double[nEqs];
        double[] yd = new double[nEqs];
        double[] dydt = new double[nEqs];
        long dtNs = tNew - tOld;
        if (dtNs == 0L) {
            double[] ret = new double[y0.length];
            System.arraycopy(y0, 0, ret, 0, y0.length);
            return ret;
        }
        long stepNs = tStepMax;
        int nStep = (int)FastMath.rint((double)((double)dtNs / (double)stepNs));
        if (nStep < 1) {
            nStep = 1;
        }
        stepNs = dtNs / (long)nStep;
        double step = (double)stepNs / (double)tUnit;
        System.arraycopy(y0, 0, y, 0, nEqs);
        long tBeg = tOld;
        for (int j = 0; j < nStep; ++j) {
            int i;
            long tMid = tBeg + stepNs / 2L;
            long tEnd = j < nStep - 1 ? tBeg + stepNs : tNew;
            dydt = g.derivn(tBeg, y);
            for (i = 0; i < nEqs; ++i) {
                k1[i] = step * dydt[i];
                yd[i] = y[i] + k1[i] * 0.5;
            }
            dydt = g.derivn(tMid, yd);
            for (i = 0; i < nEqs; ++i) {
                k2[i] = step * dydt[i];
                yd[i] = y[i] + k2[i] * 0.5;
            }
            dydt = g.derivn(tMid, yd);
            for (i = 0; i < nEqs; ++i) {
                k3[i] = step * dydt[i];
                yd[i] = y[i] + k3[i];
            }
            dydt = g.derivn(tEnd, yd);
            for (i = 0; i < nEqs; ++i) {
                double k4 = step * dydt[i];
                int n = i;
                y[n] = y[n] + ((k1[i] + k4) * 0.16666666666666666 + (k2[i] + k3[i]) * 0.3333333333333333);
            }
            tBeg = tEnd;
        }
        return y;
    }
}

