/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx;

import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Array;
import gaiasky.util.gdx.IntRenderable;
import gaiasky.util.gdx.IntRenderableSorter;
import gaiasky.util.gdx.shader.attribute.BlendingAttribute;
import java.util.Comparator;
import java.util.Objects;

public class DefaultIntRenderableSorter
implements IntRenderableSorter,
Comparator<IntRenderable> {
    private final Vector3 tmpV1 = new Vector3();
    private final Vector3 tmpV2 = new Vector3();
    private Camera camera;

    @Override
    public void sort(Camera camera, Array<IntRenderable> renderables) {
        this.camera = camera;
        renderables.sort((Comparator)this);
    }

    private void getTranslation(Matrix4 worldTransform, Vector3 center, Vector3 output) {
        if (center.isZero()) {
            worldTransform.getTranslation(output);
        } else if (!worldTransform.hasRotationOrScaling()) {
            worldTransform.getTranslation(output).add(center);
        } else {
            output.set(center).mul(worldTransform);
        }
    }

    @Override
    public int compare(IntRenderable o1, IntRenderable o2) {
        boolean b2;
        boolean b1 = o1.material.has(BlendingAttribute.Type) && ((BlendingAttribute)Objects.requireNonNull(o1.material.get((int)BlendingAttribute.Type))).blended;
        boolean bl = b2 = o2.material.has(BlendingAttribute.Type) && ((BlendingAttribute)Objects.requireNonNull(o2.material.get((int)BlendingAttribute.Type))).blended;
        if (b1 != b2) {
            return b1 ? 1 : -1;
        }
        this.getTranslation(o1.worldTransform, o1.meshPart.center, this.tmpV1);
        this.getTranslation(o2.worldTransform, o2.meshPart.center, this.tmpV2);
        float dst = (int)(1000.0f * this.camera.position.dst2(this.tmpV1)) - (int)(1000.0f * this.camera.position.dst2(this.tmpV2));
        int result = dst < 0.0f ? -1 : (dst > 0.0f ? 1 : 0);
        return b1 ? -result : result;
    }
}

