/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.IntArray;
import gaiasky.util.gdx.ModelCreator;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.jafama.FastMath;

public class IcoSphereCreator
extends ModelCreator {
    private Map<Long, Integer> middlePointIndexCache;
    Vector3 aux1 = new Vector3();
    Vector3 aux2 = new Vector3();

    public IcoSphereCreator() {
        this.name = "Icosphere";
    }

    public static void main(String[] args) {
        boolean flipNormals = true;
        IcoSphereCreator isc = new IcoSphereCreator();
        int recursion = 2;
        isc.create(1.0f, recursion, flipNormals);
        try {
            File file = File.createTempFile("icosphere_" + recursion + "_", ".obj");
            FileOutputStream os = new FileOutputStream(file);
            isc.dumpObj(os);
            os.flush();
            ((OutputStream)os).close();
            System.out.println("Vertices: " + isc.vertices.size());
            System.out.println("Normals: " + isc.normals.size());
            System.out.println("Faces: " + isc.faces.size());
            System.out.println("Model written in: " + file.getAbsolutePath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected int vertex(Vector3 p, float radius) {
        p.nor();
        this.addUV(p);
        this.vertices.add(p.scl(radius));
        Vector3 normal = p.cpy().nor();
        this.normals.add(normal);
        this.aux1.set(normal).crs(Vector3.Z);
        this.aux2.set(normal).crs(Vector3.Y);
        Vector3 tangent = this.aux2;
        if (this.aux1.len() > this.aux2.len()) {
            tangent = this.aux1;
        }
        tangent = tangent.cpy().nor();
        this.tangents.add(tangent);
        Vector3 binormal = this.aux1.set(normal).crs(tangent).cpy().nor();
        this.binormals.add(binormal);
        return this.index++;
    }

    protected void addUV(Vector3 p) {
        float u = 0.5f + (float)(Math.atan2(p.z, p.y) / (Math.PI * 2));
        float v = 0.5f - (float)(Math.asin(p.x) / Math.PI);
        if (p.equals((Object)new Vector3(1.0f, 0.0f, 0.0f))) {
            u = 0.5f;
            v = 1.0f;
        }
        if (p.equals((Object)new Vector3(-1.0f, 0.0f, 0.0f))) {
            u = 0.5f;
            v = 0.0f;
        }
        this.uv.add(new Vector2(u, v));
    }

    private void addNormals() {
        for (ModelCreator.IFace face : this.faces) {
            face.setNormals(face.v()[0], face.v()[1], face.v()[2]);
            face.setBinormals(face.v()[0], face.v()[1], face.v()[2]);
            face.setTangents(face.v()[0], face.v()[1], face.v()[2]);
        }
    }

    private int getMiddlePoint(int p1, int p2, float radius) {
        long greaterIndex;
        boolean firstIsSmaller = p1 < p2;
        long smallerIndex = firstIsSmaller ? (long)p1 : (long)p2;
        Long key = (smallerIndex << 32) + (greaterIndex = firstIsSmaller ? (long)p2 : (long)p1);
        if (this.middlePointIndexCache.containsKey(key)) {
            return this.middlePointIndexCache.get(key);
        }
        Vector3 point1 = (Vector3)this.vertices.get(p1 - 1);
        Vector3 point2 = (Vector3)this.vertices.get(p2 - 1);
        Vector3 middle = new Vector3((point1.x + point2.x) / 2.0f, (point1.y + point2.y) / 2.0f, (point1.z + point2.z) / 2.0f);
        middle.nor();
        int i = this.vertex(middle, radius);
        this.middlePointIndexCache.put(key, i);
        return i;
    }

    private IntArray detectWrappedUVCoordinates() {
        IntArray indices = new IntArray();
        for (int i = this.faces.size() - 1; i >= 0; --i) {
            ModelCreator.IFace face = (ModelCreator.IFace)this.faces.get(i);
            Vector3 texA = new Vector3((Vector2)this.uv.get(face.v()[0] - 1), 0.0f);
            Vector3 texB = new Vector3((Vector2)this.uv.get(face.v()[1] - 1), 0.0f);
            Vector3 texC = new Vector3((Vector2)this.uv.get(face.v()[2] - 1), 0.0f);
            Vector3 a = texB.cpy().sub(texA);
            Vector3 b = texC.cpy().sub(texA);
            Vector3 texNormal = a.crs(b);
            if (!(texNormal.z < 0.0f)) continue;
            indices.add(i);
        }
        return indices;
    }

    public IcoSphereCreator create(float radius, int recursionLevel) {
        return this.create(radius, recursionLevel, false);
    }

    public IcoSphereCreator create(float radius, int divisions, boolean flipNormals) {
        return this.create(radius, divisions, flipNormals, false);
    }

    public IcoSphereCreator create(float radius, int divisions, boolean flipNormals, boolean hardEdges) {
        if (divisions < 1) {
            throw new AssertionError((Object)"Recursion level must be greater than 0");
        }
        this.flipNormals = flipNormals;
        this.hardEdges = hardEdges;
        this.middlePointIndexCache = new HashMap<Long, Integer>();
        float t = (float)((1.0 + FastMath.sqrt((double)5.0)) / 2.0);
        this.vertex(new Vector3(-1.0f, t, 0.0f), radius);
        this.vertex(new Vector3(1.0f, t, 0.0f), radius);
        this.vertex(new Vector3(-1.0f, -t, 0.0f), radius);
        this.vertex(new Vector3(1.0f, -t, 0.0f), radius);
        this.vertex(new Vector3(0.0f, -1.0f, t), radius);
        this.vertex(new Vector3(0.0f, 1.0f, t), radius);
        this.vertex(new Vector3(0.0f, -1.0f, -t), radius);
        this.vertex(new Vector3(0.0f, 1.0f, -t), radius);
        this.vertex(new Vector3(t, 0.0f, -1.0f), radius);
        this.vertex(new Vector3(t, 0.0f, 1.0f), radius);
        this.vertex(new Vector3(-t, 0.0f, -1.0f), radius);
        this.vertex(new Vector3(-t, 0.0f, 1.0f), radius);
        ArrayList<ModelCreator.IFace> faces = new ArrayList<ModelCreator.IFace>();
        this.addFace(faces, flipNormals, 1, 12, 6);
        this.addFace(faces, flipNormals, 1, 6, 2);
        this.addFace(faces, flipNormals, 1, 2, 8);
        this.addFace(faces, flipNormals, 1, 8, 11);
        this.addFace(faces, flipNormals, 1, 11, 12);
        this.addFace(faces, flipNormals, 2, 6, 10);
        this.addFace(faces, flipNormals, 6, 12, 5);
        this.addFace(faces, flipNormals, 12, 11, 3);
        this.addFace(faces, flipNormals, 11, 8, 7);
        this.addFace(faces, flipNormals, 8, 2, 9);
        this.addFace(faces, flipNormals, 4, 10, 5);
        this.addFace(faces, flipNormals, 4, 5, 3);
        this.addFace(faces, flipNormals, 4, 3, 7);
        this.addFace(faces, flipNormals, 4, 7, 9);
        this.addFace(faces, flipNormals, 4, 9, 10);
        this.addFace(faces, flipNormals, 5, 10, 6);
        this.addFace(faces, flipNormals, 3, 5, 12);
        this.addFace(faces, flipNormals, 7, 3, 11);
        this.addFace(faces, flipNormals, 9, 7, 8);
        this.addFace(faces, flipNormals, 10, 9, 2);
        for (int i = 1; i < divisions; ++i) {
            ArrayList<ModelCreator.IFace> faces2 = new ArrayList<ModelCreator.IFace>();
            for (ModelCreator.IFace tri : faces) {
                int a = this.getMiddlePoint(tri.v()[0], tri.v()[1], radius);
                int b = this.getMiddlePoint(tri.v()[1], tri.v()[2], radius);
                int c = this.getMiddlePoint(tri.v()[2], tri.v()[0], radius);
                this.addFace(faces2, flipNormals, tri.v()[0], a, c);
                this.addFace(faces2, flipNormals, tri.v()[1], b, a);
                this.addFace(faces2, flipNormals, tri.v()[2], c, b);
                this.addFace(faces2, flipNormals, a, b, c);
            }
            faces = faces2;
        }
        this.faces = faces;
        this.addNormals();
        return this;
    }
}

