/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx;

import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.g3d.utils.DefaultTextureBinder;
import com.badlogic.gdx.graphics.g3d.utils.RenderContext;
import com.badlogic.gdx.graphics.g3d.utils.TextureBinder;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.FlushablePool;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.Pool;
import gaiasky.util.gdx.DefaultIntRenderableSorter;
import gaiasky.util.gdx.IntRenderable;
import gaiasky.util.gdx.IntRenderableProvider;
import gaiasky.util.gdx.IntRenderableSorter;
import gaiasky.util.gdx.shader.Environment;
import gaiasky.util.gdx.shader.IntShader;
import gaiasky.util.gdx.shader.provider.DefaultIntShaderProvider;
import gaiasky.util.gdx.shader.provider.IntShaderProvider;

public class IntModelBatch
implements Disposable {
    protected final RenderablePool renderablesPool = new RenderablePool();
    protected final Array<IntRenderable> renderables = new Array();
    protected final RenderContext context;
    protected final IntShaderProvider shaderProvider;
    protected final IntRenderableSorter sorter;
    private final boolean ownContext;
    protected Camera camera;

    public IntModelBatch(RenderContext context, IntShaderProvider shaderProvider, IntRenderableSorter sorter) {
        this.sorter = sorter == null ? new DefaultIntRenderableSorter() : sorter;
        this.ownContext = context == null;
        this.context = context == null ? new RenderContext((TextureBinder)new DefaultTextureBinder(1, 1)) : context;
        this.shaderProvider = shaderProvider == null ? new DefaultIntShaderProvider() : shaderProvider;
    }

    public IntModelBatch(RenderContext context, IntShaderProvider shaderProvider) {
        this(context, shaderProvider, null);
    }

    public IntModelBatch(RenderContext context, IntRenderableSorter sorter) {
        this(context, null, sorter);
    }

    public IntModelBatch(RenderContext context) {
        this(context, null, null);
    }

    public IntModelBatch(IntShaderProvider shaderProvider) {
        this(null, shaderProvider, null);
    }

    public IntModelBatch(IntShaderProvider shaderProvider, IntRenderableSorter sorter) {
        this(null, shaderProvider, sorter);
    }

    public IntModelBatch(String vertexShaderCode, String fragmentShaderCode) {
        this(null, new DefaultIntShaderProvider(vertexShaderCode, fragmentShaderCode), null);
    }

    public IntModelBatch() {
        this(null, null, null);
    }

    public void begin(Camera cam) {
        if (this.camera != null) {
            throw new GdxRuntimeException("Call end() first.");
        }
        this.camera = cam;
        if (this.ownContext) {
            this.context.begin();
        }
    }

    public Camera getCamera() {
        return this.camera;
    }

    public void setCamera(Camera cam) {
        if (this.camera == null) {
            throw new GdxRuntimeException("Call begin() first.");
        }
        if (this.renderables.size > 0) {
            this.flush();
        }
        this.camera = cam;
    }

    public boolean ownsRenderContext() {
        return this.ownContext;
    }

    public RenderContext getRenderContext() {
        return this.context;
    }

    public IntShaderProvider getShaderProvider() {
        return this.shaderProvider;
    }

    public IntRenderableSorter getRenderableSorter() {
        return this.sorter;
    }

    public void flush() {
        this.sorter.sort(this.camera, this.renderables);
        IntShader currentShader = null;
        for (int i = 0; i < this.renderables.size; ++i) {
            IntRenderable renderable = (IntRenderable)this.renderables.get(i);
            if (currentShader != renderable.shader) {
                if (currentShader != null) {
                    currentShader.end();
                }
                currentShader = renderable.shader;
                currentShader.begin(this.camera, this.context);
            }
            currentShader.render(renderable);
        }
        if (currentShader != null) {
            currentShader.end();
        }
        this.renderablesPool.flush();
        this.renderables.clear();
    }

    public void end() {
        this.flush();
        if (this.ownContext) {
            this.context.end();
        }
        this.camera = null;
    }

    public void cancel() {
        this.renderablesPool.flush();
        this.renderables.clear();
        if (this.ownContext) {
            this.context.end();
        }
        this.camera = null;
    }

    public void render(IntRenderable renderable) {
        renderable.shader = this.shaderProvider.getShader(renderable);
        renderable.meshPart.mesh.setAutoBind(false);
        this.renderables.add((Object)renderable);
    }

    public void render(IntRenderableProvider renderableProvider) {
        int offset = this.renderables.size;
        renderableProvider.getRenderables(this.renderables, (Pool<IntRenderable>)this.renderablesPool);
        for (int i = offset; i < this.renderables.size; ++i) {
            IntRenderable renderable = (IntRenderable)this.renderables.get(i);
            renderable.shader = this.shaderProvider.getShader(renderable);
        }
    }

    public <T extends IntRenderableProvider> void render(Iterable<T> renderableProviders) {
        for (IntRenderableProvider renderableProvider : renderableProviders) {
            this.render(renderableProvider);
        }
    }

    public void render(IntRenderableProvider renderableProvider, Environment environment) {
        int offset = this.renderables.size;
        renderableProvider.getRenderables(this.renderables, (Pool<IntRenderable>)this.renderablesPool);
        for (int i = offset; i < this.renderables.size; ++i) {
            IntRenderable renderable = (IntRenderable)this.renderables.get(i);
            renderable.environment = environment;
            renderable.shader = this.shaderProvider.getShader(renderable);
        }
    }

    public <T extends IntRenderableProvider> void render(Iterable<T> renderableProviders, Environment environment) {
        for (IntRenderableProvider renderableProvider : renderableProviders) {
            this.render(renderableProvider, environment);
        }
    }

    public void render(IntRenderableProvider renderableProvider, IntShader shader) {
        int offset = this.renderables.size;
        renderableProvider.getRenderables(this.renderables, (Pool<IntRenderable>)this.renderablesPool);
        for (int i = offset; i < this.renderables.size; ++i) {
            IntRenderable renderable = (IntRenderable)this.renderables.get(i);
            renderable.shader = shader;
            renderable.shader = this.shaderProvider.getShader(renderable);
        }
    }

    public <T extends IntRenderableProvider> void render(Iterable<T> renderableProviders, IntShader shader) {
        for (IntRenderableProvider renderableProvider : renderableProviders) {
            this.render(renderableProvider, shader);
        }
    }

    public void render(IntRenderableProvider renderableProvider, Environment environment, IntShader shader) {
        int offset = this.renderables.size;
        renderableProvider.getRenderables(this.renderables, (Pool<IntRenderable>)this.renderablesPool);
        for (int i = offset; i < this.renderables.size; ++i) {
            IntRenderable renderable = (IntRenderable)this.renderables.get(i);
            renderable.environment = environment;
            renderable.shader = shader;
            renderable.shader = this.shaderProvider.getShader(renderable);
        }
    }

    public <T extends IntRenderableProvider> void render(Iterable<T> renderableProviders, Environment environment, IntShader shader) {
        for (IntRenderableProvider renderableProvider : renderableProviders) {
            this.render(renderableProvider, environment, shader);
        }
    }

    public void dispose() {
        this.shaderProvider.dispose();
    }

    protected static class RenderablePool
    extends FlushablePool<IntRenderable> {
        protected RenderablePool() {
        }

        protected IntRenderable newObject() {
            return new IntRenderable();
        }

        public IntRenderable obtain() {
            IntRenderable renderable = (IntRenderable)super.obtain();
            renderable.environment = null;
            renderable.material = null;
            renderable.meshPart.set("", null, 0, 0, 0);
            renderable.shader = null;
            renderable.userData = null;
            return renderable;
        }
    }
}

