/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.VertexAttributes;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.GdxRuntimeException;
import gaiasky.util.Bits;
import gaiasky.util.gdx.IntIntMeshBuilder;
import gaiasky.util.gdx.IntMeshPartBuilder;
import gaiasky.util.gdx.mesh.IntMesh;
import gaiasky.util.gdx.model.IntMeshPart;
import gaiasky.util.gdx.model.IntModel;
import gaiasky.util.gdx.model.IntNode;
import gaiasky.util.gdx.model.IntNodePart;
import gaiasky.util.gdx.shader.Material;
import net.jafama.FastMath;

public class IntModelBuilder {
    private final Array<IntIntMeshBuilder> builders = new Array();
    private IntModel model;
    private IntNode node;

    public static void rebuildReferences(IntModel model) {
        model.materials.clear();
        model.meshes.clear();
        model.meshParts.clear();
        for (IntNode node : model.nodes) {
            IntModelBuilder.rebuildReferences(model, node);
        }
    }

    private static void rebuildReferences(IntModel model, IntNode node) {
        for (IntNodePart mpm : node.parts) {
            if (!model.materials.contains((Object)mpm.material, true)) {
                model.materials.add((Object)mpm.material);
            }
            if (model.meshParts.contains((Object)mpm.meshPart, true)) continue;
            model.meshParts.add((Object)mpm.meshPart);
            if (!model.meshes.contains((Object)mpm.meshPart.mesh, true)) {
                model.meshes.add((Object)mpm.meshPart.mesh);
            }
            model.manageDisposable(mpm.meshPart.mesh);
        }
        Iterable<IntNode> nodeIter = node.getChildren();
        for (IntNode child : nodeIter) {
            IntModelBuilder.rebuildReferences(model, child);
        }
    }

    @Deprecated
    public static IntModel createFromMesh(IntMesh mesh, int primitiveType, Material material) {
        return IntModelBuilder.createFromMesh(mesh, 0, mesh.getNumIndices(), primitiveType, material);
    }

    @Deprecated
    public static IntModel createFromMesh(IntMesh mesh, int indexOffset, int vertexCount, int primitiveType, Material material) {
        IntModel result = new IntModel();
        IntMeshPart meshPart = new IntMeshPart();
        meshPart.id = "part1";
        meshPart.offset = indexOffset;
        meshPart.size = vertexCount;
        meshPart.primitiveType = primitiveType;
        meshPart.mesh = mesh;
        IntNodePart partMaterial = new IntNodePart();
        partMaterial.material = material;
        partMaterial.meshPart = meshPart;
        IntNode node = new IntNode();
        node.id = "node1";
        node.parts.add((Object)partMaterial);
        result.meshes.add((Object)mesh);
        result.materials.add((Object)material);
        result.nodes.add((Object)node);
        result.meshParts.add((Object)meshPart);
        result.manageDisposable(mesh);
        result.computeSpan();
        return result;
    }

    @Deprecated
    public static IntModel createFromMesh(float[] vertices, VertexAttribute[] attributes, int[] indices, int primitiveType, Material material) {
        IntMesh mesh = new IntMesh(false, vertices.length, indices.length, attributes);
        mesh.setVertices(vertices);
        mesh.setIndices(indices);
        return IntModelBuilder.createFromMesh(mesh, 0, indices.length, primitiveType, material);
    }

    private IntIntMeshBuilder getBuilder(VertexAttributes attributes) {
        for (IntIntMeshBuilder mb : this.builders) {
            if (!mb.getAttributes().equals((Object)attributes) || mb.lastIndex() >= 0x3FFFFFFF) continue;
            return mb;
        }
        IntIntMeshBuilder result = new IntIntMeshBuilder();
        result.begin(attributes);
        this.builders.add((Object)result);
        return result;
    }

    public void begin() {
        if (this.model != null) {
            throw new GdxRuntimeException("Call end() first");
        }
        this.node = null;
        this.model = new IntModel();
        this.builders.clear();
    }

    public IntModel end() {
        if (this.model == null) {
            throw new GdxRuntimeException("Call begin() first");
        }
        IntModel result = this.model;
        this.endnode();
        this.model = null;
        for (IntIntMeshBuilder mb : this.builders) {
            mb.end();
        }
        this.builders.clear();
        IntModelBuilder.rebuildReferences(result);
        result.computeSpan();
        return result;
    }

    private void endnode() {
        if (this.node != null) {
            this.node = null;
        }
    }

    protected IntNode node(IntNode node) {
        if (this.model == null) {
            throw new GdxRuntimeException("Call begin() first");
        }
        this.endnode();
        this.model.nodes.add((Object)node);
        this.node = node;
        return node;
    }

    public IntNode node() {
        IntNode node = new IntNode();
        this.node(node);
        node.id = "node" + this.model.nodes.size;
        return node;
    }

    public IntNode node(String id, IntModel model) {
        IntNode node = new IntNode();
        node.id = id;
        node.addChildren(model.nodes);
        this.node(node);
        for (Disposable disposable : model.getManagedDisposables()) {
            this.manage(disposable);
        }
        return node;
    }

    public void manage(Disposable disposable) {
        if (this.model == null) {
            throw new GdxRuntimeException("Call begin() first");
        }
        this.model.manageDisposable(disposable);
    }

    public void part(IntMeshPart meshpart, Material material) {
        if (this.node == null) {
            this.node();
        }
        this.node.parts.add((Object)new IntNodePart(meshpart, material));
    }

    public IntMeshPart part(String id, IntMesh mesh, int primitiveType, int offset, int size, Material material) {
        IntMeshPart meshPart = new IntMeshPart();
        meshPart.id = id;
        meshPart.primitiveType = primitiveType;
        meshPart.mesh = mesh;
        meshPart.offset = offset;
        meshPart.size = size;
        this.part(meshPart, material);
        return meshPart;
    }

    public IntMeshPart part(String id, IntMesh mesh, int primitiveType, Material material) {
        return this.part(id, mesh, primitiveType, 0, mesh.getNumIndices(), material);
    }

    public IntMeshPartBuilder part(String id, int primitiveType, VertexAttributes attributes, Material material) {
        IntIntMeshBuilder builder = this.getBuilder(attributes);
        this.part(builder.part(id, primitiveType), material);
        return builder;
    }

    public IntMeshPartBuilder part(String id, int primitiveType, Bits attributes, Material material) {
        return this.part(id, primitiveType, IntIntMeshBuilder.createAttributes(attributes), material);
    }

    public IntModel createBox(float width, float height, float depth, boolean flip, Material material, Bits attributes) {
        return this.createBox(width, height, depth, flip, 4, material, attributes);
    }

    public IntModel createBox(float width, float height, float depth, boolean flip, int primitiveType, Material material, Bits attributes) {
        this.begin();
        this.part("box", primitiveType, attributes, material).box(width, height, depth, flip);
        return this.end();
    }

    public IntModel createRect(float x00, float y00, float z00, float x10, float y10, float z10, float x11, float y11, float z11, float x01, float y01, float z01, float normalX, float normalY, float normalZ, Material material, Bits attributes) {
        return this.createRect(x00, y00, z00, x10, y10, z10, x11, y11, z11, x01, y01, z01, normalX, normalY, normalZ, 4, material, attributes);
    }

    public IntModel createRect(float x00, float y00, float z00, float x10, float y10, float z10, float x11, float y11, float z11, float x01, float y01, float z01, float normalX, float normalY, float normalZ, int primitiveType, Material material, Bits attributes) {
        this.begin();
        this.part("rect", primitiveType, attributes, material).rect(x00, y00, z00, x10, y10, z10, x11, y11, z11, x01, y01, z01, normalX, normalY, normalZ);
        return this.end();
    }

    public IntModel createCylinder(float width, float height, float depth, int divisions, Material material, Bits attributes) {
        return this.createCylinder(width, height, depth, divisions, 4, material, attributes);
    }

    public IntModel createCylinder(float width, float height, float depth, int divisions, int primitiveType, Material material, Bits attributes) {
        return this.createCylinder(width, height, depth, divisions, primitiveType, material, attributes, 0.0f, 360.0f);
    }

    public IntModel createCylinder(float width, float height, float depth, int divisions, Material material, Bits attributes, float angleFrom, float angleTo) {
        return this.createCylinder(width, height, depth, divisions, 4, material, attributes, angleFrom, angleTo);
    }

    public IntModel createCylinder(float width, float height, float depth, int divisions, int primitiveType, Material material, Bits attributes, float angleFrom, float angleTo) {
        this.begin();
        this.part("cylinder", primitiveType, attributes, material).cylinder(width, height, depth, divisions, angleFrom, angleTo);
        return this.end();
    }

    public IntModel createCone(float width, float height, float depth, int divisions, Material material, Bits attributes) {
        return this.createCone(width, height, depth, divisions, 4, material, attributes);
    }

    public IntModel createCone(float width, float height, float depth, int divisions, int primitiveType, Material material, Bits attributes) {
        return this.createCone(width, height, depth, divisions, primitiveType, material, attributes, 0.0f, 360.0f);
    }

    public IntModel createCone(float width, float height, float depth, int divisions, int hdivisions, int primitiveType, Material material, Bits attributes) {
        return this.createCone(width, height, depth, divisions, hdivisions, primitiveType, material, attributes, 0.0f, 360.0f);
    }

    public IntModel createCone(float width, float height, float depth, int divisions, Material material, Bits attributes, float angleFrom, float angleTo) {
        return this.createCone(width, height, depth, divisions, 4, material, attributes, angleFrom, angleTo);
    }

    public IntModel createCone(float width, float height, float depth, int divisions, int primitiveType, Material material, Bits attributes, float angleFrom, float angleTo) {
        this.begin();
        this.part("cone", primitiveType, attributes, material).cone(width, height, depth, divisions, angleFrom, angleTo);
        return this.end();
    }

    public IntModel createCone(float width, float height, float depth, int divisions, int hdivisions, int primitiveType, Material material, Bits attributes, float angleFrom, float angleTo) {
        this.begin();
        this.part("cone", primitiveType, attributes, material).cone(width, height, depth, divisions, hdivisions, angleFrom, angleTo);
        return this.end();
    }

    public IntModel createSphere(float width, float height, float depth, int divisionsU, int divisionsV, Material material, Bits attributes) {
        return this.createSphere(width, height, depth, divisionsU, divisionsV, 4, material, attributes);
    }

    public IntModel createSphere(float width, float height, float depth, int divisionsU, int divisionsV, int primitiveType, Material material, Bits attributes) {
        return this.createSphere(width, height, depth, divisionsU, divisionsV, primitiveType, material, attributes, 0.0f, 360.0f, 0.0f, 180.0f);
    }

    public IntModel createSphere(float width, float height, float depth, int divisionsU, int divisionsV, Material material, Bits attributes, float angleUFrom, float angleUTo, float angleVFrom, float angleVTo) {
        return this.createSphere(width, height, depth, divisionsU, divisionsV, 4, material, attributes, angleUFrom, angleUTo, angleVFrom, angleVTo);
    }

    public IntModel createSphere(float width, float height, float depth, int divisionsU, int divisionsV, int primitiveType, Material material, Bits attributes, float angleUFrom, float angleUTo, float angleVFrom, float angleVTo) {
        this.begin();
        this.part("cylinder", primitiveType, attributes, material).sphere(width, height, depth, divisionsU, divisionsV, angleUFrom, angleUTo, angleVFrom, angleVTo);
        return this.end();
    }

    public IntModel createCapsule(float radius, float height, int divisions, Material material, Bits attributes) {
        return this.createCapsule(radius, height, divisions, 4, material, attributes);
    }

    public IntModel createCapsule(float radius, float height, int divisions, int primitiveType, Material material, Bits attributes) {
        this.begin();
        this.part("capsule", primitiveType, attributes, material).capsule(radius, height, divisions);
        return this.end();
    }

    public IntModel createXYZCoordinates(float axisLength, float capLength, float stemThickness, int divisions, int primitiveType, Material material, Bits attributes) {
        this.begin();
        IntMeshPartBuilder partBuilder = this.part("xyz", primitiveType, attributes, material);
        partBuilder.setColor(Color.RED);
        partBuilder.arrow(0.0f, 0.0f, 0.0f, axisLength, 0.0f, 0.0f, capLength, stemThickness, divisions);
        partBuilder.setColor(Color.GREEN);
        partBuilder.arrow(0.0f, 0.0f, 0.0f, 0.0f, axisLength, 0.0f, capLength, stemThickness, divisions);
        partBuilder.setColor(Color.BLUE);
        partBuilder.arrow(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, axisLength, capLength, stemThickness, divisions);
        return this.end();
    }

    public IntModel createXYZCoordinates(float axisLength, Material material, Bits attributes) {
        return this.createXYZCoordinates(axisLength, 0.1f, 0.1f, 5, 4, material, attributes);
    }

    public IntModel createPlane(float side, int divisionsU, int divisionsV, boolean flip, int primitiveType, Material material, Bits attributes) {
        return this.createPlane(side, side, divisionsU, divisionsV, flip, primitiveType, material, attributes);
    }

    public IntModel createPlane(float width, float height, int divisionsU, int divisionsV, boolean flip, int primitiveType, Material material, Bits attributes) {
        float zhs = width / 2.0f;
        float xhs = height / 2.0f;
        IntMeshPartBuilder.VertexInfo vt00 = new IntMeshPartBuilder.VertexInfo();
        vt00.setPos(-xhs, 0.0f, -zhs);
        vt00.setNor(0.0f, -1.0f, 0.0f);
        IntMeshPartBuilder.VertexInfo vt01 = new IntMeshPartBuilder.VertexInfo();
        vt01.setPos(xhs, 0.0f, -zhs);
        vt01.setNor(0.0f, -1.0f, 0.0f);
        IntMeshPartBuilder.VertexInfo vt11 = new IntMeshPartBuilder.VertexInfo();
        vt11.setPos(xhs, 0.0f, zhs);
        vt11.setNor(0.0f, -1.0f, 0.0f);
        IntMeshPartBuilder.VertexInfo vt10 = new IntMeshPartBuilder.VertexInfo();
        vt10.setPos(-xhs, 0.0f, zhs);
        vt10.setNor(0.0f, -1.0f, 0.0f);
        if (flip) {
            vt00.setUV(0.0f, 0.0f);
            vt01.setUV(1.0f, 0.0f);
            vt11.setUV(1.0f, 1.0f);
            vt10.setUV(0.0f, 1.0f);
        } else {
            vt01.setUV(0.0f, 0.0f);
            vt00.setUV(0.0f, 1.0f);
            vt10.setUV(1.0f, 1.0f);
            vt11.setUV(1.0f, 0.0f);
        }
        this.begin();
        this.part("plane", primitiveType, attributes, material).patch(vt00, vt01, vt11, vt10, divisionsU, divisionsV);
        return this.end();
    }

    public IntModel createArrow(float x1, float y1, float z1, float x2, float y2, float z2, float capLength, float stemThickness, int divisions, int primitiveType, Material material, Bits attributes) {
        this.begin();
        this.part("arrow", primitiveType, attributes, material).arrow(x1, y1, z1, x2, y2, z2, capLength, stemThickness, divisions);
        return this.end();
    }

    public IntModel createArrow(Vector3 from, Vector3 to, Material material, Bits attributes) {
        return this.createArrow(from.x, from.y, from.z, to.x, to.y, to.z, 0.1f, 0.1f, 5, 4, material, attributes);
    }

    public IntModel createLineGrid(int xDivisions, int zDivisions, float xSize, float zSize, Material material, Bits attributes) {
        this.begin();
        IntMeshPartBuilder partBuilder = this.part("lines", 1, attributes, material);
        float xlength = (float)xDivisions * xSize;
        float zlength = (float)zDivisions * zSize;
        float hxlength = xlength / 2.0f;
        float hzlength = zlength / 2.0f;
        float x1 = -hxlength;
        float y1 = 0.0f;
        float z1 = hzlength;
        float x2 = -hxlength;
        float y2 = 0.0f;
        float z2 = -hzlength;
        for (int i = 0; i <= xDivisions; ++i) {
            partBuilder.line(x1, y1, z1, x2, y2, z2);
            x1 += xSize;
            x2 += xSize;
        }
        x1 = -hxlength;
        y1 = 0.0f;
        z1 = -hzlength;
        x2 = hxlength;
        y2 = 0.0f;
        z2 = -hzlength;
        for (int j = 0; j <= zDivisions; ++j) {
            partBuilder.line(x1, y1, z1, x2, y2, z2);
            z1 += zSize;
            z2 += zSize;
        }
        return this.end();
    }

    public IntModel createCylinder(float width, float height, float depth, int divisions, boolean flipNormals, Material material, Bits attributes) {
        return this.createCylinder(width, height, depth, divisions, flipNormals, 4, material, attributes);
    }

    public IntModel createCylinder(float width, float height, float depth, int divisions, boolean flipNormals, int primitiveType, Material material, Bits attributes) {
        this.begin();
        this.part("cylinder", primitiveType, attributes, material).cylinder(width, height, depth, divisions, 0.0f, 360.0f, false, flipNormals);
        return this.end();
    }

    public IntModel createIcoSphere(float radius, int recursion, boolean flipNormals, boolean hardEdges, Material material, Bits attributes) {
        return this.createIcoSphere(radius, recursion, flipNormals, hardEdges, 4, material, attributes);
    }

    public IntModel createIcoSphere(float radius, int recursion, boolean flipNormals, boolean hardEdges, int primitiveType, Material material, Bits attributes) {
        this.begin();
        int nfaces = (int)(10.0 * FastMath.pow((double)2.0, (double)(2 * recursion - 1)));
        if (nfaces * 3 <= Integer.MAX_VALUE) {
            this.part("icosphere", primitiveType, attributes, material).icosphere(radius, recursion, flipNormals, hardEdges);
        } else {
            int maxfaces = 0x2AAAAAAA;
            int chunks = nfaces / maxfaces + 1;
            for (int i = 0; i < chunks; ++i) {
                int startFace = i * maxfaces;
                this.part("icosphere", primitiveType, attributes, material).icosphere(radius, recursion, flipNormals, hardEdges, startFace, maxfaces);
            }
        }
        return this.end();
    }

    public IntModel createOctahedronSphere(float radius, int divisions, boolean flipNormals, boolean hardEdges, Material material, Bits attributes) {
        return this.createOctahedronSphere(radius, divisions, flipNormals, hardEdges, 4, material, attributes);
    }

    public IntModel createOctahedronSphere(float radius, int divisions, boolean flipNormals, boolean hardEdges, int primitiveType, Material material, Bits attributes) {
        this.begin();
        this.part("octahedronsphere", primitiveType, attributes, material).octahedronsphere(radius, divisions, flipNormals, hardEdges);
        this.part("octahedronsphere", primitiveType, attributes, material).octahedronsphere(radius, divisions, flipNormals, hardEdges);
        return this.end();
    }

    public IntModel createRing(float sphereDiameter, int divisionsU, int divisionsV, float innerRingRadius, float outerRingRadius, int ringDivisions, int primitiveType, Material materialShpere, Material materialRing, Bits attributes) {
        this.begin();
        this.part("ring", primitiveType, attributes, materialRing).ring(innerRingRadius, outerRingRadius, ringDivisions, false);
        this.part("ring", primitiveType, attributes, materialRing).ring(new Matrix4().translate(0.0f, -1.0E-5f, 0.0f), innerRingRadius, outerRingRadius, ringDivisions, true);
        return this.end();
    }

    public IntModel createSphereRing(float sphereDiameter, int divisionsU, int divisionsV, float innerRingRadius, float outerRingRadius, int ringDivisions, int primitiveType, Material materialShpere, Material materialRing, Bits attributes) {
        this.begin();
        this.part("sphere", primitiveType, attributes, materialShpere).sphere(sphereDiameter, sphereDiameter, sphereDiameter, divisionsU, divisionsV, false, 0.0f, 360.0f, 0.0f, 180.0f);
        this.part("ring", primitiveType, attributes, materialRing).ring(innerRingRadius, outerRingRadius, ringDivisions, false);
        this.part("ring", primitiveType, attributes, materialRing).ring(new Matrix4().translate(0.0f, -1.0E-5f, 0.0f), innerRingRadius, outerRingRadius, ringDivisions, true);
        return this.end();
    }

    public IntModel createSphere(float diameter, int divisionsU, int divisionsV, Material material, Bits attributes) {
        return this.createSphere(diameter, diameter, diameter, divisionsU, divisionsV, false, 4, material, attributes);
    }

    public IntModel createSphere(float diameter, int divisionsU, int divisionsV, boolean flipNormals, Material material, Bits attributes) {
        return this.createSphere(diameter, diameter, diameter, divisionsU, divisionsV, flipNormals, 4, material, attributes);
    }

    public IntModel createSphere(float width, float height, float depth, int divisionsU, int divisionsV, boolean flipNormals, Material material, Bits attributes) {
        return this.createSphere(width, height, depth, divisionsU, divisionsV, flipNormals, 4, material, attributes);
    }

    public IntModel createSphere(float width, float height, float depth, int divisionsU, int divisionsV, boolean flipNormals, int primitiveType, Material material, Bits attributes) {
        return this.createSphere(width, height, depth, divisionsU, divisionsV, flipNormals, primitiveType, material, attributes, 0.0f, 360.0f, 0.0f, 180.0f);
    }

    public IntModel createSphere(float width, float height, float depth, int divisionsU, int divisionsV, boolean flipNormals, Material material, Bits attributes, float angleUFrom, float angleUTo, float angleVFrom, float angleVTo) {
        return this.createSphere(width, height, depth, divisionsU, divisionsV, flipNormals, 4, material, attributes, angleUFrom, angleUTo, angleVFrom, angleVTo);
    }

    public IntModel createSphere(float width, float height, float depth, int divisionsU, int divisionsV, boolean flipNormals, int primitiveType, Material material, Bits attributes, float angleUFrom, float angleUTo, float angleVFrom, float angleVTo) {
        this.begin();
        this.part("sphere", primitiveType, attributes, material).sphere(width, height, depth, divisionsU, divisionsV, flipNormals, angleUFrom, angleUTo, angleVFrom, angleVTo);
        return this.end();
    }
}

