/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;

public abstract class ModelCreator {
    public String name;
    public List<Vector3> vertices = new ArrayList<Vector3>();
    public List<Vector3> normals = new ArrayList<Vector3>();
    public List<Vector3> binormals = new ArrayList<Vector3>();
    public List<Vector3> tangents = new ArrayList<Vector3>();
    public List<Vector2> uv = new ArrayList<Vector2>();
    public List<IFace> faces = new ArrayList<IFace>();
    protected int index = 1;
    protected boolean flipNormals;
    protected boolean hardEdges;

    protected ModelCreator() {
    }

    protected void addFace(List<IFace> faces, boolean flipNormals, int ... v) {
        if (flipNormals) {
            faces.add(new Face(this, this.flip(v, 1)));
        } else {
            faces.add(new Face(this, v));
        }
    }

    protected int[] flip(int[] v, int startIndex) {
        for (int i = startIndex; i < v.length / 2; ++i) {
            int temp = v[i];
            v[i] = v[v.length - i + startIndex - 1];
            v[v.length - i + startIndex - 1] = temp;
        }
        return v;
    }

    protected int addVertex(Vector3 p) {
        this.vertices.add(p);
        return this.index++;
    }

    public void dumpObj(OutputStream os) throws IOException {
        DecimalFormat nf = new DecimalFormat("########0.000000");
        OutputStreamWriter osw = new OutputStreamWriter(os);
        osw.append("# Created by ").append(this.getClass().getSimpleName()).append(" - ARI - ZAH - Heidelberg Universitat\n");
        osw.append("o ").append(this.name).append("\n");
        for (Vector3 vertex : this.vertices) {
            osw.append("v ").append(nf.format(vertex.x)).append(" ").append(nf.format(vertex.y)).append(" ").append(nf.format(vertex.z)).append("\n");
        }
        for (Vector3 vertex : this.normals) {
            osw.append("vn ").append(nf.format(vertex.x)).append(" ").append(nf.format(vertex.y)).append(" ").append(nf.format(vertex.z)).append("\n");
        }
        for (IFace face : this.faces) {
            osw.append("f ");
            int[] v = face.v();
            for (int i = 0; i < v.length; ++i) {
                osw.append(this.idx(face.v()[i], face.n()[i]));
                if (i == v.length - 1) continue;
                osw.append(" ");
            }
            osw.append("\n");
        }
        osw.flush();
        osw.close();
    }

    private String idx(int vi, int ni) {
        return vi + "//" + ni;
    }

    public class Face
    implements IFace {
        public int[] v;
        public int[] n;
        public int[] t;
        public int[] b;

        public Face(ModelCreator this$0, int ... v) {
            this.v = v;
        }

        @Override
        public void setNormals(int ... n) {
            this.n = n;
        }

        @Override
        public void setBinormals(int ... n) {
            this.b = n;
        }

        @Override
        public void setTangents(int ... n) {
            this.t = n;
        }

        @Override
        public int[] v() {
            return this.v;
        }

        @Override
        public int[] n() {
            return this.n;
        }

        @Override
        public int[] t() {
            return this.t;
        }

        @Override
        public int[] b() {
            return this.b;
        }
    }

    public static interface IFace {
        public int[] v();

        public int[] n();

        public int[] b();

        public int[] t();

        public void setNormals(int ... var1);

        public void setBinormals(int ... var1);

        public void setTangents(int ... var1);
    }
}

