/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import gaiasky.util.gdx.ModelCreator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class OctahedronSphereCreator
extends ModelCreator {
    private Map<Long, Integer> middlePointIndexCache;

    public OctahedronSphereCreator() {
        this.index = 0;
    }

    protected void addUV(Set<Integer> seam) {
        int idx = 0;
        for (Vector3 vertex : this.vertices) {
            Vector3 p = new Vector3(vertex);
            p.nor();
            float u = 0.5f + (float)(Math.atan2(p.z, p.x) / (Math.PI * 2));
            float v = 0.5f - (float)(Math.asin(p.y) / Math.PI);
            if (seam.contains(idx + 1)) {
                v = 1.0f;
            }
            this.uv.add(new Vector2(u, v));
            ++idx;
        }
    }

    private void addNormals() {
        for (ModelCreator.IFace face : this.faces) {
            if (this.hardEdges) {
                Vector3 a = ((Vector3)this.vertices.get(face.v()[1])).cpy().sub((Vector3)this.vertices.get(face.v()[0]));
                Vector3 b = ((Vector3)this.vertices.get(face.v()[2])).cpy().sub((Vector3)this.vertices.get(face.v()[1]));
                this.normals.add(a.crs(b).nor());
                int idx = this.normals.size();
                face.setNormals(idx, idx, idx);
                continue;
            }
            this.normals.add(((Vector3)this.vertices.get(face.v()[0])).cpy().nor());
            this.normals.add(((Vector3)this.vertices.get(face.v()[1])).cpy().nor());
            this.normals.add(((Vector3)this.vertices.get(face.v()[2])).cpy().nor());
            int idx = this.normals.size();
            face.setNormals(idx - 3, idx - 2, idx - 1);
        }
    }

    private int getMiddlePoint(int p1, int p2, float radius) {
        long greaterIndex;
        boolean firstIsSmaller = p1 < p2;
        long smallerIndex = firstIsSmaller ? (long)p1 : (long)p2;
        long key = (smallerIndex << 32) + (greaterIndex = firstIsSmaller ? (long)p2 : (long)p1);
        if (this.middlePointIndexCache.containsKey(key)) {
            return this.middlePointIndexCache.get(key);
        }
        Vector3 point1 = (Vector3)this.vertices.get(p1);
        Vector3 point2 = (Vector3)this.vertices.get(p2);
        Vector3 middle = new Vector3((point1.x + point2.x) / 2.0f, (point1.y + point2.y) / 2.0f, (point1.z + point2.z) / 2.0f);
        middle.nor().scl(radius);
        int i = this.addVertex(middle);
        this.middlePointIndexCache.put(key, i);
        return i;
    }

    public OctahedronSphereCreator create(float radius, int divisions, boolean flipNormals, boolean hardEdges) {
        if (divisions < 0 || divisions > 6) {
            throw new AssertionError((Object)"Divisions must be in [0..6]");
        }
        this.flipNormals = flipNormals;
        this.hardEdges = hardEdges;
        this.middlePointIndexCache = new HashMap<Long, Integer>();
        this.addVertex(new Vector3(0.0f, radius, 0.0f));
        this.addVertex(new Vector3(0.0f, 0.0f, radius));
        this.addVertex(new Vector3(radius, 0.0f, 0.0f));
        this.addVertex(new Vector3(0.0f, 0.0f, -radius));
        this.addVertex(new Vector3(-radius, 0.0f, 0.0f));
        this.addVertex(new Vector3(0.0f, -radius, 0.0f));
        int[] triangles = new int[]{0, 1, 2, 0, 2, 3, 0, 3, 4, 0, 4, 1, 5, 2, 1, 5, 3, 2, 5, 4, 3, 5, 1, 4};
        ArrayList<ModelCreator.IFace> faces = new ArrayList<ModelCreator.IFace>();
        for (int f = 0; f < 8; ++f) {
            this.addFace(faces, flipNormals, triangles[f * 3], triangles[f * 3 + 1], triangles[f * 3 + 2]);
        }
        for (int division = 0; division < divisions; ++division) {
            ArrayList<ModelCreator.IFace> faces2 = new ArrayList<ModelCreator.IFace>();
            for (ModelCreator.IFace face : faces) {
                int f0 = face.v()[0];
                int f1 = face.v()[1];
                int f2 = face.v()[2];
                int a = this.getMiddlePoint(f0, f1, radius);
                int b = this.getMiddlePoint(f1, f2, radius);
                int c = this.getMiddlePoint(f2, f0, radius);
                this.addFace(faces2, flipNormals, face.v()[0], a, c);
                this.addFace(faces2, flipNormals, face.v()[1], b, a);
                this.addFace(faces2, flipNormals, face.v()[2], c, b);
                this.addFace(faces2, flipNormals, a, b, c);
            }
            faces = faces2;
        }
        this.faces = faces;
        this.addNormals();
        return this;
    }
}

